package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  KMSArn,
  FlowDescription,
  FlowName,
  TagValue,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateFlowRequest(
    flowName: FlowName,
    description: Optional[FlowDescription] = Optional.Absent,
    kmsArn: Optional[KMSArn] = Optional.Absent,
    triggerConfig: zio.aws.appflow.model.TriggerConfig,
    sourceFlowConfig: zio.aws.appflow.model.SourceFlowConfig,
    destinationFlowConfigList: Iterable[
      zio.aws.appflow.model.DestinationFlowConfig
    ],
    tasks: Iterable[zio.aws.appflow.model.Task],
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.CreateFlowRequest = {
    import CreateFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.CreateFlowRequest
      .builder()
      .flowName(FlowName.unwrap(flowName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          FlowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        kmsArn.map(value => KMSArn.unwrap(value): java.lang.String)
      )(_.kmsArn)
      .triggerConfig(triggerConfig.buildAwsValue())
      .sourceFlowConfig(sourceFlowConfig.buildAwsValue())
      .destinationFlowConfigList(destinationFlowConfigList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .tasks(tasks.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.CreateFlowRequest.ReadOnly =
    zio.aws.appflow.model.CreateFlowRequest.wrap(buildAwsValue())
}
object CreateFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.CreateFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.CreateFlowRequest =
      zio.aws.appflow.model.CreateFlowRequest(
        flowName,
        description.map(value => value),
        kmsArn.map(value => value),
        triggerConfig.asEditable,
        sourceFlowConfig.asEditable,
        destinationFlowConfigList.map { item =>
          item.asEditable
        },
        tasks.map { item =>
          item.asEditable
        },
        tags.map(value => value)
      )
    def flowName: FlowName
    def description: Optional[FlowDescription]
    def kmsArn: Optional[KMSArn]
    def triggerConfig: zio.aws.appflow.model.TriggerConfig.ReadOnly
    def sourceFlowConfig: zio.aws.appflow.model.SourceFlowConfig.ReadOnly
    def destinationFlowConfigList
        : List[zio.aws.appflow.model.DestinationFlowConfig.ReadOnly]
    def tasks: List[zio.aws.appflow.model.Task.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getFlowName: ZIO[Any, Nothing, FlowName] = ZIO.succeed(flowName)
    def getDescription: ZIO[Any, AwsError, FlowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getKmsArn: ZIO[Any, AwsError, KMSArn] =
      AwsError.unwrapOptionField("kmsArn", kmsArn)
    def getTriggerConfig
        : ZIO[Any, Nothing, zio.aws.appflow.model.TriggerConfig.ReadOnly] =
      ZIO.succeed(triggerConfig)
    def getSourceFlowConfig
        : ZIO[Any, Nothing, zio.aws.appflow.model.SourceFlowConfig.ReadOnly] =
      ZIO.succeed(sourceFlowConfig)
    def getDestinationFlowConfigList: ZIO[Any, Nothing, List[
      zio.aws.appflow.model.DestinationFlowConfig.ReadOnly
    ]] = ZIO.succeed(destinationFlowConfigList)
    def getTasks: ZIO[Any, Nothing, List[zio.aws.appflow.model.Task.ReadOnly]] =
      ZIO.succeed(tasks)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.CreateFlowRequest
  ) extends zio.aws.appflow.model.CreateFlowRequest.ReadOnly {
    override val flowName: FlowName =
      zio.aws.appflow.model.primitives.FlowName(impl.flowName())
    override val description: Optional[FlowDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appflow.model.primitives.FlowDescription(value))
    override val kmsArn: Optional[KMSArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsArn())
      .map(value => zio.aws.appflow.model.primitives.KMSArn(value))
    override val triggerConfig: zio.aws.appflow.model.TriggerConfig.ReadOnly =
      zio.aws.appflow.model.TriggerConfig.wrap(impl.triggerConfig())
    override val sourceFlowConfig
        : zio.aws.appflow.model.SourceFlowConfig.ReadOnly =
      zio.aws.appflow.model.SourceFlowConfig.wrap(impl.sourceFlowConfig())
    override val destinationFlowConfigList
        : List[zio.aws.appflow.model.DestinationFlowConfig.ReadOnly] = impl
      .destinationFlowConfigList()
      .asScala
      .map { item =>
        zio.aws.appflow.model.DestinationFlowConfig.wrap(item)
      }
      .toList
    override val tasks: List[zio.aws.appflow.model.Task.ReadOnly] = impl
      .tasks()
      .asScala
      .map { item =>
        zio.aws.appflow.model.Task.wrap(item)
      }
      .toList
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appflow.model.primitives
              .TagKey(key) -> zio.aws.appflow.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.CreateFlowRequest
  ): zio.aws.appflow.model.CreateFlowRequest.ReadOnly = new Wrapper(impl)
}
