package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.CustomAuthenticationType
import scala.jdk.CollectionConverters.*
final case class CustomAuthConfig(
    customAuthenticationType: Optional[CustomAuthenticationType] =
      Optional.Absent,
    authParameters: Optional[Iterable[zio.aws.appflow.model.AuthParameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.CustomAuthConfig = {
    import CustomAuthConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.CustomAuthConfig
      .builder()
      .optionallyWith(
        customAuthenticationType.map(value =>
          CustomAuthenticationType.unwrap(value): java.lang.String
        )
      )(_.customAuthenticationType)
      .optionallyWith(
        authParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.authParameters)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.CustomAuthConfig.ReadOnly =
    zio.aws.appflow.model.CustomAuthConfig.wrap(buildAwsValue())
}
object CustomAuthConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.CustomAuthConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.CustomAuthConfig =
      zio.aws.appflow.model.CustomAuthConfig(
        customAuthenticationType.map(value => value),
        authParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def customAuthenticationType: Optional[CustomAuthenticationType]
    def authParameters
        : Optional[List[zio.aws.appflow.model.AuthParameter.ReadOnly]]
    def getCustomAuthenticationType
        : ZIO[Any, AwsError, CustomAuthenticationType] = AwsError
      .unwrapOptionField("customAuthenticationType", customAuthenticationType)
    def getAuthParameters: ZIO[Any, AwsError, List[
      zio.aws.appflow.model.AuthParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("authParameters", authParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.CustomAuthConfig
  ) extends zio.aws.appflow.model.CustomAuthConfig.ReadOnly {
    override val customAuthenticationType: Optional[CustomAuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customAuthenticationType())
        .map(value =>
          zio.aws.appflow.model.primitives.CustomAuthenticationType(value)
        )
    override val authParameters
        : Optional[List[zio.aws.appflow.model.AuthParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.AuthParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.CustomAuthConfig
  ): zio.aws.appflow.model.CustomAuthConfig.ReadOnly = new Wrapper(impl)
}
