package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  ProfilePropertyValue,
  ProfilePropertyKey
}
import scala.jdk.CollectionConverters.*
final case class CustomConnectorProfileProperties(
    profileProperties: Optional[Map[ProfilePropertyKey, ProfilePropertyValue]] =
      Optional.Absent,
    oAuth2Properties: Optional[zio.aws.appflow.model.OAuth2Properties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.CustomConnectorProfileProperties = {
    import CustomConnectorProfileProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.CustomConnectorProfileProperties
      .builder()
      .optionallyWith(
        profileProperties.map(value =>
          value
            .map({ case (key, value) =>
              (ProfilePropertyKey
                .unwrap(key): java.lang.String) -> (ProfilePropertyValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.profileProperties)
      .optionallyWith(oAuth2Properties.map(value => value.buildAwsValue()))(
        _.oAuth2Properties
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.CustomConnectorProfileProperties.ReadOnly =
    zio.aws.appflow.model.CustomConnectorProfileProperties.wrap(buildAwsValue())
}
object CustomConnectorProfileProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.CustomConnectorProfileProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.CustomConnectorProfileProperties =
      zio.aws.appflow.model.CustomConnectorProfileProperties(
        profileProperties.map(value => value),
        oAuth2Properties.map(value => value.asEditable)
      )
    def profileProperties
        : Optional[Map[ProfilePropertyKey, ProfilePropertyValue]]
    def oAuth2Properties
        : Optional[zio.aws.appflow.model.OAuth2Properties.ReadOnly]
    def getProfileProperties
        : ZIO[Any, AwsError, Map[ProfilePropertyKey, ProfilePropertyValue]] =
      AwsError.unwrapOptionField("profileProperties", profileProperties)
    def getOAuth2Properties
        : ZIO[Any, AwsError, zio.aws.appflow.model.OAuth2Properties.ReadOnly] =
      AwsError.unwrapOptionField("oAuth2Properties", oAuth2Properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.CustomConnectorProfileProperties
  ) extends zio.aws.appflow.model.CustomConnectorProfileProperties.ReadOnly {
    override val profileProperties
        : Optional[Map[ProfilePropertyKey, ProfilePropertyValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profileProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appflow.model.primitives.ProfilePropertyKey(
                key
              ) -> zio.aws.appflow.model.primitives.ProfilePropertyValue(value)
            })
            .toMap
        )
    override val oAuth2Properties
        : Optional[zio.aws.appflow.model.OAuth2Properties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oAuth2Properties())
        .map(value => zio.aws.appflow.model.OAuth2Properties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.CustomConnectorProfileProperties
  ): zio.aws.appflow.model.CustomConnectorProfileProperties.ReadOnly =
    new Wrapper(impl)
}
