package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  CustomPropertyValue,
  CustomPropertyKey,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class CustomConnectorSourceProperties(
    entityName: EntityName,
    customProperties: Optional[Map[CustomPropertyKey, CustomPropertyValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.CustomConnectorSourceProperties = {
    import CustomConnectorSourceProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.CustomConnectorSourceProperties
      .builder()
      .entityName(EntityName.unwrap(entityName): java.lang.String)
      .optionallyWith(
        customProperties.map(value =>
          value
            .map({ case (key, value) =>
              (CustomPropertyKey
                .unwrap(key): java.lang.String) -> (CustomPropertyValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.customProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.CustomConnectorSourceProperties.ReadOnly =
    zio.aws.appflow.model.CustomConnectorSourceProperties.wrap(buildAwsValue())
}
object CustomConnectorSourceProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.CustomConnectorSourceProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.CustomConnectorSourceProperties =
      zio.aws.appflow.model.CustomConnectorSourceProperties(
        entityName,
        customProperties.map(value => value)
      )
    def entityName: EntityName
    def customProperties: Optional[Map[CustomPropertyKey, CustomPropertyValue]]
    def getEntityName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(entityName)
    def getCustomProperties
        : ZIO[Any, AwsError, Map[CustomPropertyKey, CustomPropertyValue]] =
      AwsError.unwrapOptionField("customProperties", customProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.CustomConnectorSourceProperties
  ) extends zio.aws.appflow.model.CustomConnectorSourceProperties.ReadOnly {
    override val entityName: EntityName =
      zio.aws.appflow.model.primitives.EntityName(impl.entityName())
    override val customProperties
        : Optional[Map[CustomPropertyKey, CustomPropertyValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appflow.model.primitives.CustomPropertyKey(
                key
              ) -> zio.aws.appflow.model.primitives.CustomPropertyValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.CustomConnectorSourceProperties
  ): zio.aws.appflow.model.CustomConnectorSourceProperties.ReadOnly =
    new Wrapper(impl)
}
