package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{ObjectTypeName, DomainName}
import scala.jdk.CollectionConverters.*
final case class CustomerProfilesDestinationProperties(
    domainName: DomainName,
    objectTypeName: Optional[ObjectTypeName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.CustomerProfilesDestinationProperties = {
    import CustomerProfilesDestinationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.CustomerProfilesDestinationProperties
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        objectTypeName.map(value =>
          ObjectTypeName.unwrap(value): java.lang.String
        )
      )(_.objectTypeName)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.CustomerProfilesDestinationProperties.ReadOnly =
    zio.aws.appflow.model.CustomerProfilesDestinationProperties
      .wrap(buildAwsValue())
}
object CustomerProfilesDestinationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.CustomerProfilesDestinationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appflow.model.CustomerProfilesDestinationProperties =
      zio.aws.appflow.model.CustomerProfilesDestinationProperties(
        domainName,
        objectTypeName.map(value => value)
      )
    def domainName: DomainName
    def objectTypeName: Optional[ObjectTypeName]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getObjectTypeName: ZIO[Any, AwsError, ObjectTypeName] =
      AwsError.unwrapOptionField("objectTypeName", objectTypeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.CustomerProfilesDestinationProperties
  ) extends zio.aws.appflow.model.CustomerProfilesDestinationProperties.ReadOnly {
    override val domainName: DomainName =
      zio.aws.appflow.model.primitives.DomainName(impl.domainName())
    override val objectTypeName: Optional[ObjectTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectTypeName())
        .map(value => zio.aws.appflow.model.primitives.ObjectTypeName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.CustomerProfilesDestinationProperties
  ): zio.aws.appflow.model.CustomerProfilesDestinationProperties.ReadOnly =
    new Wrapper(impl)
}
