package zio.aws.appflow.model
import scala.jdk.CollectionConverters.*
sealed trait DataPullMode {
  def unwrap: software.amazon.awssdk.services.appflow.model.DataPullMode
}
object DataPullMode {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.DataPullMode
  ): zio.aws.appflow.model.DataPullMode = value match {
    case software.amazon.awssdk.services.appflow.model.DataPullMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.DataPullMode.INCREMENTAL =>
      val r = Incremental
      r
    case software.amazon.awssdk.services.appflow.model.DataPullMode.COMPLETE =>
      val r = Complete
      r
  }
  case object unknownToSdkVersion extends zio.aws.appflow.model.DataPullMode {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DataPullMode =
      software.amazon.awssdk.services.appflow.model.DataPullMode.UNKNOWN_TO_SDK_VERSION
  }
  case object Incremental extends zio.aws.appflow.model.DataPullMode {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DataPullMode =
      software.amazon.awssdk.services.appflow.model.DataPullMode.INCREMENTAL
  }
  case object Complete extends zio.aws.appflow.model.DataPullMode {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DataPullMode =
      software.amazon.awssdk.services.appflow.model.DataPullMode.COMPLETE
  }
}
