package zio.aws.appflow.model
import scala.jdk.CollectionConverters.*
sealed trait DatadogConnectorOperator {
  def unwrap
      : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator
}
object DatadogConnectorOperator {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator
  ): zio.aws.appflow.model.DatadogConnectorOperator = value match {
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.PROJECTION =>
      val r = PROJECTION
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.BETWEEN =>
      val r = BETWEEN
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.EQUAL_TO =>
      val r = EQUAL_TO
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.ADDITION =>
      val r = ADDITION
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.MULTIPLICATION =>
      val r = MULTIPLICATION
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.DIVISION =>
      val r = DIVISION
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.SUBTRACTION =>
      val r = SUBTRACTION
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.MASK_ALL =>
      val r = MASK_ALL
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.MASK_FIRST_N =>
      val r = MASK_FIRST_N
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.MASK_LAST_N =>
      val r = MASK_LAST_N
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.VALIDATE_NON_NULL =>
      val r = VALIDATE_NON_NULL
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.VALIDATE_NON_ZERO =>
      val r = VALIDATE_NON_ZERO
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.VALIDATE_NON_NEGATIVE =>
      val r = VALIDATE_NON_NEGATIVE
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.VALIDATE_NUMERIC =>
      val r = VALIDATE_NUMERIC
      r
    case software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.NO_OP =>
      val r = NO_OP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object PROJECTION
      extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.PROJECTION
  }
  case object BETWEEN extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.BETWEEN
  }
  case object EQUAL_TO extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.EQUAL_TO
  }
  case object ADDITION extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.ADDITION
  }
  case object MULTIPLICATION
      extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.MULTIPLICATION
  }
  case object DIVISION extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.DIVISION
  }
  case object SUBTRACTION
      extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.SUBTRACTION
  }
  case object MASK_ALL extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.MASK_ALL
  }
  case object MASK_FIRST_N
      extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.MASK_FIRST_N
  }
  case object MASK_LAST_N
      extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.MASK_LAST_N
  }
  case object VALIDATE_NON_NULL
      extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.VALIDATE_NON_NULL
  }
  case object VALIDATE_NON_ZERO
      extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.VALIDATE_NON_ZERO
  }
  case object VALIDATE_NON_NEGATIVE
      extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.VALIDATE_NON_NEGATIVE
  }
  case object VALIDATE_NUMERIC
      extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.VALIDATE_NUMERIC
  }
  case object NO_OP extends zio.aws.appflow.model.DatadogConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator =
      software.amazon.awssdk.services.appflow.model.DatadogConnectorOperator.NO_OP
  }
}
