package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.{ApplicationKey, ApiKey}
import scala.jdk.CollectionConverters.*
final case class DatadogConnectorProfileCredentials(
    apiKey: ApiKey,
    applicationKey: ApplicationKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DatadogConnectorProfileCredentials = {
    import DatadogConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DatadogConnectorProfileCredentials
      .builder()
      .apiKey(ApiKey.unwrap(apiKey): java.lang.String)
      .applicationKey(ApplicationKey.unwrap(applicationKey): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.DatadogConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.DatadogConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object DatadogConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DatadogConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DatadogConnectorProfileCredentials =
      zio.aws.appflow.model
        .DatadogConnectorProfileCredentials(apiKey, applicationKey)
    def apiKey: ApiKey
    def applicationKey: ApplicationKey
    def getApiKey: ZIO[Any, Nothing, ApiKey] = ZIO.succeed(apiKey)
    def getApplicationKey: ZIO[Any, Nothing, ApplicationKey] =
      ZIO.succeed(applicationKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DatadogConnectorProfileCredentials
  ) extends zio.aws.appflow.model.DatadogConnectorProfileCredentials.ReadOnly {
    override val apiKey: ApiKey =
      zio.aws.appflow.model.primitives.ApiKey(impl.apiKey())
    override val applicationKey: ApplicationKey =
      zio.aws.appflow.model.primitives.ApplicationKey(impl.applicationKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DatadogConnectorProfileCredentials
  ): zio.aws.appflow.model.DatadogConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
