package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.InstanceUrl
import scala.jdk.CollectionConverters.*
final case class DatadogConnectorProfileProperties(instanceUrl: InstanceUrl) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DatadogConnectorProfileProperties = {
    import DatadogConnectorProfileProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DatadogConnectorProfileProperties
      .builder()
      .instanceUrl(InstanceUrl.unwrap(instanceUrl): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.DatadogConnectorProfileProperties.ReadOnly =
    zio.aws.appflow.model.DatadogConnectorProfileProperties
      .wrap(buildAwsValue())
}
object DatadogConnectorProfileProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DatadogConnectorProfileProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DatadogConnectorProfileProperties =
      zio.aws.appflow.model.DatadogConnectorProfileProperties(instanceUrl)
    def instanceUrl: InstanceUrl
    def getInstanceUrl: ZIO[Any, Nothing, InstanceUrl] =
      ZIO.succeed(instanceUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DatadogConnectorProfileProperties
  ) extends zio.aws.appflow.model.DatadogConnectorProfileProperties.ReadOnly {
    override val instanceUrl: InstanceUrl =
      zio.aws.appflow.model.primitives.InstanceUrl(impl.instanceUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DatadogConnectorProfileProperties
  ): zio.aws.appflow.model.DatadogConnectorProfileProperties.ReadOnly =
    new Wrapper(impl)
}
