package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.ConnectorProfileName
import scala.jdk.CollectionConverters.*
final case class DeleteConnectorProfileRequest(
    connectorProfileName: ConnectorProfileName,
    forceDelete: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileRequest = {
    import DeleteConnectorProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileRequest
      .builder()
      .connectorProfileName(
        ConnectorProfileName.unwrap(connectorProfileName): java.lang.String
      )
      .optionallyWith(forceDelete.map(value => value: java.lang.Boolean))(
        _.forceDelete
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.DeleteConnectorProfileRequest.ReadOnly =
    zio.aws.appflow.model.DeleteConnectorProfileRequest.wrap(buildAwsValue())
}
object DeleteConnectorProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DeleteConnectorProfileRequest =
      zio.aws.appflow.model.DeleteConnectorProfileRequest(
        connectorProfileName,
        forceDelete.map(value => value)
      )
    def connectorProfileName: ConnectorProfileName
    def forceDelete: Optional[Boolean]
    def getConnectorProfileName: ZIO[Any, Nothing, ConnectorProfileName] =
      ZIO.succeed(connectorProfileName)
    def getForceDelete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDelete", forceDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileRequest
  ) extends zio.aws.appflow.model.DeleteConnectorProfileRequest.ReadOnly {
    override val connectorProfileName: ConnectorProfileName =
      zio.aws.appflow.model.primitives
        .ConnectorProfileName(impl.connectorProfileName())
    override val forceDelete: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.forceDelete())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DeleteConnectorProfileRequest
  ): zio.aws.appflow.model.DeleteConnectorProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
