package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.FlowName
import scala.jdk.CollectionConverters.*
final case class DeleteFlowRequest(
    flowName: FlowName,
    forceDelete: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DeleteFlowRequest = {
    import DeleteFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DeleteFlowRequest
      .builder()
      .flowName(FlowName.unwrap(flowName): java.lang.String)
      .optionallyWith(forceDelete.map(value => value: java.lang.Boolean))(
        _.forceDelete
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.DeleteFlowRequest.ReadOnly =
    zio.aws.appflow.model.DeleteFlowRequest.wrap(buildAwsValue())
}
object DeleteFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DeleteFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DeleteFlowRequest =
      zio.aws.appflow.model
        .DeleteFlowRequest(flowName, forceDelete.map(value => value))
    def flowName: FlowName
    def forceDelete: Optional[Boolean]
    def getFlowName: ZIO[Any, Nothing, FlowName] = ZIO.succeed(flowName)
    def getForceDelete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDelete", forceDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DeleteFlowRequest
  ) extends zio.aws.appflow.model.DeleteFlowRequest.ReadOnly {
    override val flowName: FlowName =
      zio.aws.appflow.model.primitives.FlowName(impl.flowName())
    override val forceDelete: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.forceDelete())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DeleteFlowRequest
  ): zio.aws.appflow.model.DeleteFlowRequest.ReadOnly = new Wrapper(impl)
}
