package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.ConnectorLabel
import scala.jdk.CollectionConverters.*
final case class DescribeConnectorRequest(
    connectorType: zio.aws.appflow.model.ConnectorType,
    connectorLabel: Optional[ConnectorLabel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DescribeConnectorRequest = {
    import DescribeConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DescribeConnectorRequest
      .builder()
      .connectorType(connectorType.unwrap)
      .optionallyWith(
        connectorLabel.map(value =>
          ConnectorLabel.unwrap(value): java.lang.String
        )
      )(_.connectorLabel)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.DescribeConnectorRequest.ReadOnly =
    zio.aws.appflow.model.DescribeConnectorRequest.wrap(buildAwsValue())
}
object DescribeConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DescribeConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DescribeConnectorRequest =
      zio.aws.appflow.model.DescribeConnectorRequest(
        connectorType,
        connectorLabel.map(value => value)
      )
    def connectorType: zio.aws.appflow.model.ConnectorType
    def connectorLabel: Optional[ConnectorLabel]
    def getConnectorType
        : ZIO[Any, Nothing, zio.aws.appflow.model.ConnectorType] =
      ZIO.succeed(connectorType)
    def getConnectorLabel: ZIO[Any, AwsError, ConnectorLabel] =
      AwsError.unwrapOptionField("connectorLabel", connectorLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorRequest
  ) extends zio.aws.appflow.model.DescribeConnectorRequest.ReadOnly {
    override val connectorType: zio.aws.appflow.model.ConnectorType =
      zio.aws.appflow.model.ConnectorType.wrap(impl.connectorType())
    override val connectorLabel: Optional[ConnectorLabel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorLabel())
        .map(value => zio.aws.appflow.model.primitives.ConnectorLabel(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorRequest
  ): zio.aws.appflow.model.DescribeConnectorRequest.ReadOnly = new Wrapper(impl)
}
