package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConnectorResponse(
    connectorConfiguration: Optional[
      zio.aws.appflow.model.ConnectorConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DescribeConnectorResponse = {
    import DescribeConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DescribeConnectorResponse
      .builder()
      .optionallyWith(
        connectorConfiguration.map(value => value.buildAwsValue())
      )(_.connectorConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.DescribeConnectorResponse.ReadOnly =
    zio.aws.appflow.model.DescribeConnectorResponse.wrap(buildAwsValue())
}
object DescribeConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DescribeConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DescribeConnectorResponse =
      zio.aws.appflow.model.DescribeConnectorResponse(
        connectorConfiguration.map(value => value.asEditable)
      )
    def connectorConfiguration
        : Optional[zio.aws.appflow.model.ConnectorConfiguration.ReadOnly]
    def getConnectorConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ConnectorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "connectorConfiguration",
      connectorConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorResponse
  ) extends zio.aws.appflow.model.DescribeConnectorResponse.ReadOnly {
    override val connectorConfiguration
        : Optional[zio.aws.appflow.model.ConnectorConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorConfiguration())
        .map(value => zio.aws.appflow.model.ConnectorConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorResponse
  ): zio.aws.appflow.model.DescribeConnectorResponse.ReadOnly = new Wrapper(
    impl
  )
}
