package zio.aws.appflow.model
import zio.aws.appflow.model.primitives.{NextToken, MaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeConnectorsRequest(
    connectorTypes: Optional[Iterable[zio.aws.appflow.model.ConnectorType]] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest = {
    import DescribeConnectorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest
      .builder()
      .optionallyWith(
        connectorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.connectorTypesWithStrings)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.DescribeConnectorsRequest.ReadOnly =
    zio.aws.appflow.model.DescribeConnectorsRequest.wrap(buildAwsValue())
}
object DescribeConnectorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DescribeConnectorsRequest =
      zio.aws.appflow.model.DescribeConnectorsRequest(
        connectorTypes.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def connectorTypes: Optional[List[zio.aws.appflow.model.ConnectorType]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getConnectorTypes
        : ZIO[Any, AwsError, List[zio.aws.appflow.model.ConnectorType]] =
      AwsError.unwrapOptionField("connectorTypes", connectorTypes)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest
  ) extends zio.aws.appflow.model.DescribeConnectorsRequest.ReadOnly {
    override val connectorTypes
        : Optional[List[zio.aws.appflow.model.ConnectorType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.ConnectorType.wrap(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appflow.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appflow.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DescribeConnectorsRequest
  ): zio.aws.appflow.model.DescribeConnectorsRequest.ReadOnly = new Wrapper(
    impl
  )
}
