package zio.aws.appflow.model
import zio.aws.appflow.model.primitives.{
  KMSArn,
  UpdatedBy,
  Date,
  FlowDescription,
  FlowName,
  TagValue,
  FlowArn,
  FlowStatusMessage,
  CreatedBy,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeFlowResponse(
    flowArn: Optional[FlowArn] = Optional.Absent,
    description: Optional[FlowDescription] = Optional.Absent,
    flowName: Optional[FlowName] = Optional.Absent,
    kmsArn: Optional[KMSArn] = Optional.Absent,
    flowStatus: Optional[zio.aws.appflow.model.FlowStatus] = Optional.Absent,
    flowStatusMessage: Optional[FlowStatusMessage] = Optional.Absent,
    sourceFlowConfig: Optional[zio.aws.appflow.model.SourceFlowConfig] =
      Optional.Absent,
    destinationFlowConfigList: Optional[
      Iterable[zio.aws.appflow.model.DestinationFlowConfig]
    ] = Optional.Absent,
    lastRunExecutionDetails: Optional[zio.aws.appflow.model.ExecutionDetails] =
      Optional.Absent,
    triggerConfig: Optional[zio.aws.appflow.model.TriggerConfig] =
      Optional.Absent,
    tasks: Optional[Iterable[zio.aws.appflow.model.Task]] = Optional.Absent,
    createdAt: Optional[Date] = Optional.Absent,
    lastUpdatedAt: Optional[Date] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    lastUpdatedBy: Optional[UpdatedBy] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DescribeFlowResponse = {
    import DescribeFlowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DescribeFlowResponse
      .builder()
      .optionallyWith(
        flowArn.map(value => FlowArn.unwrap(value): java.lang.String)
      )(_.flowArn)
      .optionallyWith(
        description.map(value =>
          FlowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        flowName.map(value => FlowName.unwrap(value): java.lang.String)
      )(_.flowName)
      .optionallyWith(
        kmsArn.map(value => KMSArn.unwrap(value): java.lang.String)
      )(_.kmsArn)
      .optionallyWith(flowStatus.map(value => value.unwrap))(_.flowStatus)
      .optionallyWith(
        flowStatusMessage.map(value =>
          FlowStatusMessage.unwrap(value): java.lang.String
        )
      )(_.flowStatusMessage)
      .optionallyWith(sourceFlowConfig.map(value => value.buildAwsValue()))(
        _.sourceFlowConfig
      )
      .optionallyWith(
        destinationFlowConfigList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationFlowConfigList)
      .optionallyWith(
        lastRunExecutionDetails.map(value => value.buildAwsValue())
      )(_.lastRunExecutionDetails)
      .optionallyWith(triggerConfig.map(value => value.buildAwsValue()))(
        _.triggerConfig
      )
      .optionallyWith(
        tasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tasks)
      .optionallyWith(createdAt.map(value => Date.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(lastUpdatedAt.map(value => Date.unwrap(value): Instant))(
        _.lastUpdatedAt
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        lastUpdatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.lastUpdatedBy)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.DescribeFlowResponse.ReadOnly =
    zio.aws.appflow.model.DescribeFlowResponse.wrap(buildAwsValue())
}
object DescribeFlowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DescribeFlowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DescribeFlowResponse =
      zio.aws.appflow.model.DescribeFlowResponse(
        flowArn.map(value => value),
        description.map(value => value),
        flowName.map(value => value),
        kmsArn.map(value => value),
        flowStatus.map(value => value),
        flowStatusMessage.map(value => value),
        sourceFlowConfig.map(value => value.asEditable),
        destinationFlowConfigList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastRunExecutionDetails.map(value => value.asEditable),
        triggerConfig.map(value => value.asEditable),
        tasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        createdBy.map(value => value),
        lastUpdatedBy.map(value => value),
        tags.map(value => value)
      )
    def flowArn: Optional[FlowArn]
    def description: Optional[FlowDescription]
    def flowName: Optional[FlowName]
    def kmsArn: Optional[KMSArn]
    def flowStatus: Optional[zio.aws.appflow.model.FlowStatus]
    def flowStatusMessage: Optional[FlowStatusMessage]
    def sourceFlowConfig
        : Optional[zio.aws.appflow.model.SourceFlowConfig.ReadOnly]
    def destinationFlowConfigList
        : Optional[List[zio.aws.appflow.model.DestinationFlowConfig.ReadOnly]]
    def lastRunExecutionDetails
        : Optional[zio.aws.appflow.model.ExecutionDetails.ReadOnly]
    def triggerConfig: Optional[zio.aws.appflow.model.TriggerConfig.ReadOnly]
    def tasks: Optional[List[zio.aws.appflow.model.Task.ReadOnly]]
    def createdAt: Optional[Date]
    def lastUpdatedAt: Optional[Date]
    def createdBy: Optional[CreatedBy]
    def lastUpdatedBy: Optional[UpdatedBy]
    def tags: Optional[Map[TagKey, TagValue]]
    def getFlowArn: ZIO[Any, AwsError, FlowArn] =
      AwsError.unwrapOptionField("flowArn", flowArn)
    def getDescription: ZIO[Any, AwsError, FlowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFlowName: ZIO[Any, AwsError, FlowName] =
      AwsError.unwrapOptionField("flowName", flowName)
    def getKmsArn: ZIO[Any, AwsError, KMSArn] =
      AwsError.unwrapOptionField("kmsArn", kmsArn)
    def getFlowStatus: ZIO[Any, AwsError, zio.aws.appflow.model.FlowStatus] =
      AwsError.unwrapOptionField("flowStatus", flowStatus)
    def getFlowStatusMessage: ZIO[Any, AwsError, FlowStatusMessage] =
      AwsError.unwrapOptionField("flowStatusMessage", flowStatusMessage)
    def getSourceFlowConfig
        : ZIO[Any, AwsError, zio.aws.appflow.model.SourceFlowConfig.ReadOnly] =
      AwsError.unwrapOptionField("sourceFlowConfig", sourceFlowConfig)
    def getDestinationFlowConfigList: ZIO[Any, AwsError, List[
      zio.aws.appflow.model.DestinationFlowConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "destinationFlowConfigList",
      destinationFlowConfigList
    )
    def getLastRunExecutionDetails
        : ZIO[Any, AwsError, zio.aws.appflow.model.ExecutionDetails.ReadOnly] =
      AwsError.unwrapOptionField(
        "lastRunExecutionDetails",
        lastRunExecutionDetails
      )
    def getTriggerConfig
        : ZIO[Any, AwsError, zio.aws.appflow.model.TriggerConfig.ReadOnly] =
      AwsError.unwrapOptionField("triggerConfig", triggerConfig)
    def getTasks
        : ZIO[Any, AwsError, List[zio.aws.appflow.model.Task.ReadOnly]] =
      AwsError.unwrapOptionField("tasks", tasks)
    def getCreatedAt: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("lastUpdatedBy", lastUpdatedBy)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DescribeFlowResponse
  ) extends zio.aws.appflow.model.DescribeFlowResponse.ReadOnly {
    override val flowArn: Optional[FlowArn] = zio.aws.core.internal
      .optionalFromNullable(impl.flowArn())
      .map(value => zio.aws.appflow.model.primitives.FlowArn(value))
    override val description: Optional[FlowDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appflow.model.primitives.FlowDescription(value))
    override val flowName: Optional[FlowName] = zio.aws.core.internal
      .optionalFromNullable(impl.flowName())
      .map(value => zio.aws.appflow.model.primitives.FlowName(value))
    override val kmsArn: Optional[KMSArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsArn())
      .map(value => zio.aws.appflow.model.primitives.KMSArn(value))
    override val flowStatus: Optional[zio.aws.appflow.model.FlowStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowStatus())
        .map(value => zio.aws.appflow.model.FlowStatus.wrap(value))
    override val flowStatusMessage: Optional[FlowStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowStatusMessage())
        .map(value => zio.aws.appflow.model.primitives.FlowStatusMessage(value))
    override val sourceFlowConfig
        : Optional[zio.aws.appflow.model.SourceFlowConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceFlowConfig())
        .map(value => zio.aws.appflow.model.SourceFlowConfig.wrap(value))
    override val destinationFlowConfigList
        : Optional[List[zio.aws.appflow.model.DestinationFlowConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationFlowConfigList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.DestinationFlowConfig.wrap(item)
          }.toList
        )
    override val lastRunExecutionDetails
        : Optional[zio.aws.appflow.model.ExecutionDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRunExecutionDetails())
        .map(value => zio.aws.appflow.model.ExecutionDetails.wrap(value))
    override val triggerConfig
        : Optional[zio.aws.appflow.model.TriggerConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.triggerConfig())
        .map(value => zio.aws.appflow.model.TriggerConfig.wrap(value))
    override val tasks: Optional[List[zio.aws.appflow.model.Task.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tasks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.Task.wrap(item)
          }.toList
        )
    override val createdAt: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val lastUpdatedAt: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.appflow.model.primitives.CreatedBy(value))
    override val lastUpdatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedBy())
      .map(value => zio.aws.appflow.model.primitives.UpdatedBy(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appflow.model.primitives
              .TagKey(key) -> zio.aws.appflow.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DescribeFlowResponse
  ): zio.aws.appflow.model.DescribeFlowResponse.ReadOnly = new Wrapper(impl)
}
