package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DestinationFieldProperties(
    isCreatable: Optional[Boolean] = Optional.Absent,
    isNullable: Optional[Boolean] = Optional.Absent,
    isUpsertable: Optional[Boolean] = Optional.Absent,
    isUpdatable: Optional[Boolean] = Optional.Absent,
    isDefaultedOnCreate: Optional[Boolean] = Optional.Absent,
    supportedWriteOperations: Optional[
      Iterable[zio.aws.appflow.model.WriteOperationType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DestinationFieldProperties = {
    import DestinationFieldProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DestinationFieldProperties
      .builder()
      .optionallyWith(isCreatable.map(value => value: java.lang.Boolean))(
        _.isCreatable
      )
      .optionallyWith(isNullable.map(value => value: java.lang.Boolean))(
        _.isNullable
      )
      .optionallyWith(isUpsertable.map(value => value: java.lang.Boolean))(
        _.isUpsertable
      )
      .optionallyWith(isUpdatable.map(value => value: java.lang.Boolean))(
        _.isUpdatable
      )
      .optionallyWith(
        isDefaultedOnCreate.map(value => value: java.lang.Boolean)
      )(_.isDefaultedOnCreate)
      .optionallyWith(
        supportedWriteOperations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedWriteOperationsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.DestinationFieldProperties.ReadOnly =
    zio.aws.appflow.model.DestinationFieldProperties.wrap(buildAwsValue())
}
object DestinationFieldProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DestinationFieldProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DestinationFieldProperties =
      zio.aws.appflow.model.DestinationFieldProperties(
        isCreatable.map(value => value),
        isNullable.map(value => value),
        isUpsertable.map(value => value),
        isUpdatable.map(value => value),
        isDefaultedOnCreate.map(value => value),
        supportedWriteOperations.map(value => value)
      )
    def isCreatable: Optional[Boolean]
    def isNullable: Optional[Boolean]
    def isUpsertable: Optional[Boolean]
    def isUpdatable: Optional[Boolean]
    def isDefaultedOnCreate: Optional[Boolean]
    def supportedWriteOperations
        : Optional[List[zio.aws.appflow.model.WriteOperationType]]
    def getIsCreatable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isCreatable", isCreatable)
    def getIsNullable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isNullable", isNullable)
    def getIsUpsertable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isUpsertable", isUpsertable)
    def getIsUpdatable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isUpdatable", isUpdatable)
    def getIsDefaultedOnCreate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefaultedOnCreate", isDefaultedOnCreate)
    def getSupportedWriteOperations
        : ZIO[Any, AwsError, List[zio.aws.appflow.model.WriteOperationType]] =
      AwsError.unwrapOptionField(
        "supportedWriteOperations",
        supportedWriteOperations
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DestinationFieldProperties
  ) extends zio.aws.appflow.model.DestinationFieldProperties.ReadOnly {
    override val isCreatable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isCreatable())
      .map(value => value: Boolean)
    override val isNullable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isNullable())
      .map(value => value: Boolean)
    override val isUpsertable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isUpsertable())
      .map(value => value: Boolean)
    override val isUpdatable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isUpdatable())
      .map(value => value: Boolean)
    override val isDefaultedOnCreate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefaultedOnCreate())
      .map(value => value: Boolean)
    override val supportedWriteOperations
        : Optional[List[zio.aws.appflow.model.WriteOperationType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedWriteOperations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.WriteOperationType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DestinationFieldProperties
  ): zio.aws.appflow.model.DestinationFieldProperties.ReadOnly = new Wrapper(
    impl
  )
}
