package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.ApiToken
import scala.jdk.CollectionConverters.*
final case class DynatraceConnectorProfileCredentials(apiToken: ApiToken) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.DynatraceConnectorProfileCredentials = {
    import DynatraceConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.DynatraceConnectorProfileCredentials
      .builder()
      .apiToken(ApiToken.unwrap(apiToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.DynatraceConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.DynatraceConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object DynatraceConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.DynatraceConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.DynatraceConnectorProfileCredentials =
      zio.aws.appflow.model.DynatraceConnectorProfileCredentials(apiToken)
    def apiToken: ApiToken
    def getApiToken: ZIO[Any, Nothing, ApiToken] = ZIO.succeed(apiToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.DynatraceConnectorProfileCredentials
  ) extends zio.aws.appflow.model.DynatraceConnectorProfileCredentials.ReadOnly {
    override val apiToken: ApiToken =
      zio.aws.appflow.model.primitives.ApiToken(impl.apiToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.DynatraceConnectorProfileCredentials
  ): zio.aws.appflow.model.DynatraceConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
