package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{BucketName, BucketPrefix}
import scala.jdk.CollectionConverters.*
final case class ErrorHandlingConfig(
    failOnFirstDestinationError: Optional[Boolean] = Optional.Absent,
    bucketPrefix: Optional[BucketPrefix] = Optional.Absent,
    bucketName: Optional[BucketName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ErrorHandlingConfig = {
    import ErrorHandlingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ErrorHandlingConfig
      .builder()
      .optionallyWith(
        failOnFirstDestinationError.map(value => value: java.lang.Boolean)
      )(_.failOnFirstDestinationError)
      .optionallyWith(
        bucketPrefix.map(value => BucketPrefix.unwrap(value): java.lang.String)
      )(_.bucketPrefix)
      .optionallyWith(
        bucketName.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucketName)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly =
    zio.aws.appflow.model.ErrorHandlingConfig.wrap(buildAwsValue())
}
object ErrorHandlingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ErrorHandlingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ErrorHandlingConfig =
      zio.aws.appflow.model.ErrorHandlingConfig(
        failOnFirstDestinationError.map(value => value),
        bucketPrefix.map(value => value),
        bucketName.map(value => value)
      )
    def failOnFirstDestinationError: Optional[Boolean]
    def bucketPrefix: Optional[BucketPrefix]
    def bucketName: Optional[BucketName]
    def getFailOnFirstDestinationError: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "failOnFirstDestinationError",
        failOnFirstDestinationError
      )
    def getBucketPrefix: ZIO[Any, AwsError, BucketPrefix] =
      AwsError.unwrapOptionField("bucketPrefix", bucketPrefix)
    def getBucketName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucketName", bucketName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ErrorHandlingConfig
  ) extends zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly {
    override val failOnFirstDestinationError: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failOnFirstDestinationError())
        .map(value => value: Boolean)
    override val bucketPrefix: Optional[BucketPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketPrefix())
      .map(value => zio.aws.appflow.model.primitives.BucketPrefix(value))
    override val bucketName: Optional[BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => zio.aws.appflow.model.primitives.BucketName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ErrorHandlingConfig
  ): zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly = new Wrapper(impl)
}
