package zio.aws.appflow.model
import zio.aws.appflow.model.primitives.{Date, MostRecentExecutionMessage}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ExecutionDetails(
    mostRecentExecutionMessage: Optional[MostRecentExecutionMessage] =
      Optional.Absent,
    mostRecentExecutionTime: Optional[Date] = Optional.Absent,
    mostRecentExecutionStatus: Optional[zio.aws.appflow.model.ExecutionStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ExecutionDetails = {
    import ExecutionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ExecutionDetails
      .builder()
      .optionallyWith(
        mostRecentExecutionMessage.map(value =>
          MostRecentExecutionMessage.unwrap(value): java.lang.String
        )
      )(_.mostRecentExecutionMessage)
      .optionallyWith(
        mostRecentExecutionTime.map(value => Date.unwrap(value): Instant)
      )(_.mostRecentExecutionTime)
      .optionallyWith(mostRecentExecutionStatus.map(value => value.unwrap))(
        _.mostRecentExecutionStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ExecutionDetails.ReadOnly =
    zio.aws.appflow.model.ExecutionDetails.wrap(buildAwsValue())
}
object ExecutionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ExecutionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ExecutionDetails =
      zio.aws.appflow.model.ExecutionDetails(
        mostRecentExecutionMessage.map(value => value),
        mostRecentExecutionTime.map(value => value),
        mostRecentExecutionStatus.map(value => value)
      )
    def mostRecentExecutionMessage: Optional[MostRecentExecutionMessage]
    def mostRecentExecutionTime: Optional[Date]
    def mostRecentExecutionStatus
        : Optional[zio.aws.appflow.model.ExecutionStatus]
    def getMostRecentExecutionMessage
        : ZIO[Any, AwsError, MostRecentExecutionMessage] =
      AwsError.unwrapOptionField(
        "mostRecentExecutionMessage",
        mostRecentExecutionMessage
      )
    def getMostRecentExecutionTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("mostRecentExecutionTime", mostRecentExecutionTime)
    def getMostRecentExecutionStatus
        : ZIO[Any, AwsError, zio.aws.appflow.model.ExecutionStatus] = AwsError
      .unwrapOptionField("mostRecentExecutionStatus", mostRecentExecutionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ExecutionDetails
  ) extends zio.aws.appflow.model.ExecutionDetails.ReadOnly {
    override val mostRecentExecutionMessage
        : Optional[MostRecentExecutionMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.mostRecentExecutionMessage())
      .map(value =>
        zio.aws.appflow.model.primitives.MostRecentExecutionMessage(value)
      )
    override val mostRecentExecutionTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.mostRecentExecutionTime())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val mostRecentExecutionStatus
        : Optional[zio.aws.appflow.model.ExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mostRecentExecutionStatus())
        .map(value => zio.aws.appflow.model.ExecutionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ExecutionDetails
  ): zio.aws.appflow.model.ExecutionDetails.ReadOnly = new Wrapper(impl)
}
