package zio.aws.appflow.model
import zio.aws.appflow.model.primitives.{Date, ExecutionId}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ExecutionRecord(
    executionId: Optional[ExecutionId] = Optional.Absent,
    executionStatus: Optional[zio.aws.appflow.model.ExecutionStatus] =
      Optional.Absent,
    executionResult: Optional[zio.aws.appflow.model.ExecutionResult] =
      Optional.Absent,
    startedAt: Optional[Date] = Optional.Absent,
    lastUpdatedAt: Optional[Date] = Optional.Absent,
    dataPullStartTime: Optional[Date] = Optional.Absent,
    dataPullEndTime: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ExecutionRecord = {
    import ExecutionRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ExecutionRecord
      .builder()
      .optionallyWith(
        executionId.map(value => ExecutionId.unwrap(value): java.lang.String)
      )(_.executionId)
      .optionallyWith(executionStatus.map(value => value.unwrap))(
        _.executionStatus
      )
      .optionallyWith(executionResult.map(value => value.buildAwsValue()))(
        _.executionResult
      )
      .optionallyWith(startedAt.map(value => Date.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(lastUpdatedAt.map(value => Date.unwrap(value): Instant))(
        _.lastUpdatedAt
      )
      .optionallyWith(
        dataPullStartTime.map(value => Date.unwrap(value): Instant)
      )(_.dataPullStartTime)
      .optionallyWith(
        dataPullEndTime.map(value => Date.unwrap(value): Instant)
      )(_.dataPullEndTime)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ExecutionRecord.ReadOnly =
    zio.aws.appflow.model.ExecutionRecord.wrap(buildAwsValue())
}
object ExecutionRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ExecutionRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ExecutionRecord =
      zio.aws.appflow.model.ExecutionRecord(
        executionId.map(value => value),
        executionStatus.map(value => value),
        executionResult.map(value => value.asEditable),
        startedAt.map(value => value),
        lastUpdatedAt.map(value => value),
        dataPullStartTime.map(value => value),
        dataPullEndTime.map(value => value)
      )
    def executionId: Optional[ExecutionId]
    def executionStatus: Optional[zio.aws.appflow.model.ExecutionStatus]
    def executionResult
        : Optional[zio.aws.appflow.model.ExecutionResult.ReadOnly]
    def startedAt: Optional[Date]
    def lastUpdatedAt: Optional[Date]
    def dataPullStartTime: Optional[Date]
    def dataPullEndTime: Optional[Date]
    def getExecutionId: ZIO[Any, AwsError, ExecutionId] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getExecutionStatus
        : ZIO[Any, AwsError, zio.aws.appflow.model.ExecutionStatus] =
      AwsError.unwrapOptionField("executionStatus", executionStatus)
    def getExecutionResult
        : ZIO[Any, AwsError, zio.aws.appflow.model.ExecutionResult.ReadOnly] =
      AwsError.unwrapOptionField("executionResult", executionResult)
    def getStartedAt: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getDataPullStartTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("dataPullStartTime", dataPullStartTime)
    def getDataPullEndTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("dataPullEndTime", dataPullEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ExecutionRecord
  ) extends zio.aws.appflow.model.ExecutionRecord.ReadOnly {
    override val executionId: Optional[ExecutionId] = zio.aws.core.internal
      .optionalFromNullable(impl.executionId())
      .map(value => zio.aws.appflow.model.primitives.ExecutionId(value))
    override val executionStatus
        : Optional[zio.aws.appflow.model.ExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionStatus())
        .map(value => zio.aws.appflow.model.ExecutionStatus.wrap(value))
    override val executionResult
        : Optional[zio.aws.appflow.model.ExecutionResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionResult())
        .map(value => zio.aws.appflow.model.ExecutionResult.wrap(value))
    override val startedAt: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val lastUpdatedAt: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val dataPullStartTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.dataPullStartTime())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val dataPullEndTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.dataPullEndTime())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ExecutionRecord
  ): zio.aws.appflow.model.ExecutionRecord.ReadOnly = new Wrapper(impl)
}
