package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{Value, FieldType}
import scala.jdk.CollectionConverters.*
final case class FieldTypeDetails(
    fieldType: FieldType,
    filterOperators: Iterable[zio.aws.appflow.model.Operator],
    supportedValues: Optional[Iterable[Value]] = Optional.Absent,
    valueRegexPattern: Optional[String] = Optional.Absent,
    supportedDateFormat: Optional[String] = Optional.Absent,
    fieldValueRange: Optional[zio.aws.appflow.model.Range] = Optional.Absent,
    fieldLengthRange: Optional[zio.aws.appflow.model.Range] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.FieldTypeDetails = {
    import FieldTypeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.FieldTypeDetails
      .builder()
      .fieldType(FieldType.unwrap(fieldType): java.lang.String)
      .filterOperatorsWithStrings(filterOperators.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        supportedValues.map(value =>
          value.map { item =>
            Value.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedValues)
      .optionallyWith(valueRegexPattern.map(value => value: java.lang.String))(
        _.valueRegexPattern
      )
      .optionallyWith(
        supportedDateFormat.map(value => value: java.lang.String)
      )(_.supportedDateFormat)
      .optionallyWith(fieldValueRange.map(value => value.buildAwsValue()))(
        _.fieldValueRange
      )
      .optionallyWith(fieldLengthRange.map(value => value.buildAwsValue()))(
        _.fieldLengthRange
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.FieldTypeDetails.ReadOnly =
    zio.aws.appflow.model.FieldTypeDetails.wrap(buildAwsValue())
}
object FieldTypeDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.FieldTypeDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.FieldTypeDetails =
      zio.aws.appflow.model.FieldTypeDetails(
        fieldType,
        filterOperators,
        supportedValues.map(value => value),
        valueRegexPattern.map(value => value),
        supportedDateFormat.map(value => value),
        fieldValueRange.map(value => value.asEditable),
        fieldLengthRange.map(value => value.asEditable)
      )
    def fieldType: FieldType
    def filterOperators: List[zio.aws.appflow.model.Operator]
    def supportedValues: Optional[List[Value]]
    def valueRegexPattern: Optional[String]
    def supportedDateFormat: Optional[String]
    def fieldValueRange: Optional[zio.aws.appflow.model.Range.ReadOnly]
    def fieldLengthRange: Optional[zio.aws.appflow.model.Range.ReadOnly]
    def getFieldType: ZIO[Any, Nothing, FieldType] = ZIO.succeed(fieldType)
    def getFilterOperators
        : ZIO[Any, Nothing, List[zio.aws.appflow.model.Operator]] =
      ZIO.succeed(filterOperators)
    def getSupportedValues: ZIO[Any, AwsError, List[Value]] =
      AwsError.unwrapOptionField("supportedValues", supportedValues)
    def getValueRegexPattern: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("valueRegexPattern", valueRegexPattern)
    def getSupportedDateFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportedDateFormat", supportedDateFormat)
    def getFieldValueRange
        : ZIO[Any, AwsError, zio.aws.appflow.model.Range.ReadOnly] =
      AwsError.unwrapOptionField("fieldValueRange", fieldValueRange)
    def getFieldLengthRange
        : ZIO[Any, AwsError, zio.aws.appflow.model.Range.ReadOnly] =
      AwsError.unwrapOptionField("fieldLengthRange", fieldLengthRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.FieldTypeDetails
  ) extends zio.aws.appflow.model.FieldTypeDetails.ReadOnly {
    override val fieldType: FieldType =
      zio.aws.appflow.model.primitives.FieldType(impl.fieldType())
    override val filterOperators: List[zio.aws.appflow.model.Operator] = impl
      .filterOperators()
      .asScala
      .map { item =>
        zio.aws.appflow.model.Operator.wrap(item)
      }
      .toList
    override val supportedValues: Optional[List[Value]] = zio.aws.core.internal
      .optionalFromNullable(impl.supportedValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appflow.model.primitives.Value(item)
        }.toList
      )
    override val valueRegexPattern: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.valueRegexPattern())
      .map(value => value: String)
    override val supportedDateFormat: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supportedDateFormat())
      .map(value => value: String)
    override val fieldValueRange
        : Optional[zio.aws.appflow.model.Range.ReadOnly] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldValueRange())
      .map(value => zio.aws.appflow.model.Range.wrap(value))
    override val fieldLengthRange
        : Optional[zio.aws.appflow.model.Range.ReadOnly] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldLengthRange())
      .map(value => zio.aws.appflow.model.Range.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.FieldTypeDetails
  ): zio.aws.appflow.model.FieldTypeDetails.ReadOnly = new Wrapper(impl)
}
