package zio.aws.appflow.model
import scala.jdk.CollectionConverters.*
sealed trait FileType {
  def unwrap: software.amazon.awssdk.services.appflow.model.FileType
}
object FileType {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.FileType
  ): zio.aws.appflow.model.FileType = value match {
    case software.amazon.awssdk.services.appflow.model.FileType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.FileType.CSV =>
      val r = CSV
      r
    case software.amazon.awssdk.services.appflow.model.FileType.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.appflow.model.FileType.PARQUET =>
      val r = PARQUET
      r
  }
  case object unknownToSdkVersion extends zio.aws.appflow.model.FileType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.FileType =
      software.amazon.awssdk.services.appflow.model.FileType.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.appflow.model.FileType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.FileType =
      software.amazon.awssdk.services.appflow.model.FileType.CSV
  }
  case object JSON extends zio.aws.appflow.model.FileType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.FileType =
      software.amazon.awssdk.services.appflow.model.FileType.JSON
  }
  case object PARQUET extends zio.aws.appflow.model.FileType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.FileType =
      software.amazon.awssdk.services.appflow.model.FileType.PARQUET
  }
}
