package zio.aws.appflow.model
import zio.aws.appflow.model.primitives.{
  UpdatedBy,
  Date,
  FlowDescription,
  FlowName,
  TagValue,
  FlowArn,
  ConnectorLabel,
  CreatedBy,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class FlowDefinition(
    flowArn: Optional[FlowArn] = Optional.Absent,
    description: Optional[FlowDescription] = Optional.Absent,
    flowName: Optional[FlowName] = Optional.Absent,
    flowStatus: Optional[zio.aws.appflow.model.FlowStatus] = Optional.Absent,
    sourceConnectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      Optional.Absent,
    sourceConnectorLabel: Optional[ConnectorLabel] = Optional.Absent,
    destinationConnectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      Optional.Absent,
    destinationConnectorLabel: Optional[ConnectorLabel] = Optional.Absent,
    triggerType: Optional[zio.aws.appflow.model.TriggerType] = Optional.Absent,
    createdAt: Optional[Date] = Optional.Absent,
    lastUpdatedAt: Optional[Date] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    lastUpdatedBy: Optional[UpdatedBy] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    lastRunExecutionDetails: Optional[zio.aws.appflow.model.ExecutionDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.FlowDefinition = {
    import FlowDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.FlowDefinition
      .builder()
      .optionallyWith(
        flowArn.map(value => FlowArn.unwrap(value): java.lang.String)
      )(_.flowArn)
      .optionallyWith(
        description.map(value =>
          FlowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        flowName.map(value => FlowName.unwrap(value): java.lang.String)
      )(_.flowName)
      .optionallyWith(flowStatus.map(value => value.unwrap))(_.flowStatus)
      .optionallyWith(sourceConnectorType.map(value => value.unwrap))(
        _.sourceConnectorType
      )
      .optionallyWith(
        sourceConnectorLabel.map(value =>
          ConnectorLabel.unwrap(value): java.lang.String
        )
      )(_.sourceConnectorLabel)
      .optionallyWith(destinationConnectorType.map(value => value.unwrap))(
        _.destinationConnectorType
      )
      .optionallyWith(
        destinationConnectorLabel.map(value =>
          ConnectorLabel.unwrap(value): java.lang.String
        )
      )(_.destinationConnectorLabel)
      .optionallyWith(triggerType.map(value => value.unwrap))(_.triggerType)
      .optionallyWith(createdAt.map(value => Date.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(lastUpdatedAt.map(value => Date.unwrap(value): Instant))(
        _.lastUpdatedAt
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        lastUpdatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.lastUpdatedBy)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        lastRunExecutionDetails.map(value => value.buildAwsValue())
      )(_.lastRunExecutionDetails)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.FlowDefinition.ReadOnly =
    zio.aws.appflow.model.FlowDefinition.wrap(buildAwsValue())
}
object FlowDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.FlowDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.FlowDefinition =
      zio.aws.appflow.model.FlowDefinition(
        flowArn.map(value => value),
        description.map(value => value),
        flowName.map(value => value),
        flowStatus.map(value => value),
        sourceConnectorType.map(value => value),
        sourceConnectorLabel.map(value => value),
        destinationConnectorType.map(value => value),
        destinationConnectorLabel.map(value => value),
        triggerType.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        createdBy.map(value => value),
        lastUpdatedBy.map(value => value),
        tags.map(value => value),
        lastRunExecutionDetails.map(value => value.asEditable)
      )
    def flowArn: Optional[FlowArn]
    def description: Optional[FlowDescription]
    def flowName: Optional[FlowName]
    def flowStatus: Optional[zio.aws.appflow.model.FlowStatus]
    def sourceConnectorType: Optional[zio.aws.appflow.model.ConnectorType]
    def sourceConnectorLabel: Optional[ConnectorLabel]
    def destinationConnectorType: Optional[zio.aws.appflow.model.ConnectorType]
    def destinationConnectorLabel: Optional[ConnectorLabel]
    def triggerType: Optional[zio.aws.appflow.model.TriggerType]
    def createdAt: Optional[Date]
    def lastUpdatedAt: Optional[Date]
    def createdBy: Optional[CreatedBy]
    def lastUpdatedBy: Optional[UpdatedBy]
    def tags: Optional[Map[TagKey, TagValue]]
    def lastRunExecutionDetails
        : Optional[zio.aws.appflow.model.ExecutionDetails.ReadOnly]
    def getFlowArn: ZIO[Any, AwsError, FlowArn] =
      AwsError.unwrapOptionField("flowArn", flowArn)
    def getDescription: ZIO[Any, AwsError, FlowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFlowName: ZIO[Any, AwsError, FlowName] =
      AwsError.unwrapOptionField("flowName", flowName)
    def getFlowStatus: ZIO[Any, AwsError, zio.aws.appflow.model.FlowStatus] =
      AwsError.unwrapOptionField("flowStatus", flowStatus)
    def getSourceConnectorType
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectorType] =
      AwsError.unwrapOptionField("sourceConnectorType", sourceConnectorType)
    def getSourceConnectorLabel: ZIO[Any, AwsError, ConnectorLabel] =
      AwsError.unwrapOptionField("sourceConnectorLabel", sourceConnectorLabel)
    def getDestinationConnectorType
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectorType] = AwsError
      .unwrapOptionField("destinationConnectorType", destinationConnectorType)
    def getDestinationConnectorLabel: ZIO[Any, AwsError, ConnectorLabel] =
      AwsError.unwrapOptionField(
        "destinationConnectorLabel",
        destinationConnectorLabel
      )
    def getTriggerType: ZIO[Any, AwsError, zio.aws.appflow.model.TriggerType] =
      AwsError.unwrapOptionField("triggerType", triggerType)
    def getCreatedAt: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("lastUpdatedBy", lastUpdatedBy)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLastRunExecutionDetails
        : ZIO[Any, AwsError, zio.aws.appflow.model.ExecutionDetails.ReadOnly] =
      AwsError.unwrapOptionField(
        "lastRunExecutionDetails",
        lastRunExecutionDetails
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.FlowDefinition
  ) extends zio.aws.appflow.model.FlowDefinition.ReadOnly {
    override val flowArn: Optional[FlowArn] = zio.aws.core.internal
      .optionalFromNullable(impl.flowArn())
      .map(value => zio.aws.appflow.model.primitives.FlowArn(value))
    override val description: Optional[FlowDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appflow.model.primitives.FlowDescription(value))
    override val flowName: Optional[FlowName] = zio.aws.core.internal
      .optionalFromNullable(impl.flowName())
      .map(value => zio.aws.appflow.model.primitives.FlowName(value))
    override val flowStatus: Optional[zio.aws.appflow.model.FlowStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowStatus())
        .map(value => zio.aws.appflow.model.FlowStatus.wrap(value))
    override val sourceConnectorType
        : Optional[zio.aws.appflow.model.ConnectorType] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceConnectorType())
      .map(value => zio.aws.appflow.model.ConnectorType.wrap(value))
    override val sourceConnectorLabel: Optional[ConnectorLabel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceConnectorLabel())
        .map(value => zio.aws.appflow.model.primitives.ConnectorLabel(value))
    override val destinationConnectorType
        : Optional[zio.aws.appflow.model.ConnectorType] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationConnectorType())
      .map(value => zio.aws.appflow.model.ConnectorType.wrap(value))
    override val destinationConnectorLabel: Optional[ConnectorLabel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationConnectorLabel())
        .map(value => zio.aws.appflow.model.primitives.ConnectorLabel(value))
    override val triggerType: Optional[zio.aws.appflow.model.TriggerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.triggerType())
        .map(value => zio.aws.appflow.model.TriggerType.wrap(value))
    override val createdAt: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val lastUpdatedAt: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.appflow.model.primitives.Date(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.appflow.model.primitives.CreatedBy(value))
    override val lastUpdatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedBy())
      .map(value => zio.aws.appflow.model.primitives.UpdatedBy(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appflow.model.primitives
              .TagKey(key) -> zio.aws.appflow.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val lastRunExecutionDetails
        : Optional[zio.aws.appflow.model.ExecutionDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRunExecutionDetails())
        .map(value => zio.aws.appflow.model.ExecutionDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.FlowDefinition
  ): zio.aws.appflow.model.FlowDefinition.ReadOnly = new Wrapper(impl)
}
