package zio.aws.appflow.model
import scala.jdk.CollectionConverters.*
sealed trait FlowStatus {
  def unwrap: software.amazon.awssdk.services.appflow.model.FlowStatus
}
object FlowStatus {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.FlowStatus
  ): zio.aws.appflow.model.FlowStatus = value match {
    case software.amazon.awssdk.services.appflow.model.FlowStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.FlowStatus.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.appflow.model.FlowStatus.DEPRECATED =>
      val r = Deprecated
      r
    case software.amazon.awssdk.services.appflow.model.FlowStatus.DELETED =>
      val r = Deleted
      r
    case software.amazon.awssdk.services.appflow.model.FlowStatus.DRAFT =>
      val r = Draft
      r
    case software.amazon.awssdk.services.appflow.model.FlowStatus.ERRORED =>
      val r = Errored
      r
    case software.amazon.awssdk.services.appflow.model.FlowStatus.SUSPENDED =>
      val r = Suspended
      r
  }
  case object unknownToSdkVersion extends zio.aws.appflow.model.FlowStatus {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.FlowStatus =
      software.amazon.awssdk.services.appflow.model.FlowStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.appflow.model.FlowStatus {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.FlowStatus =
      software.amazon.awssdk.services.appflow.model.FlowStatus.ACTIVE
  }
  case object Deprecated extends zio.aws.appflow.model.FlowStatus {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.FlowStatus =
      software.amazon.awssdk.services.appflow.model.FlowStatus.DEPRECATED
  }
  case object Deleted extends zio.aws.appflow.model.FlowStatus {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.FlowStatus =
      software.amazon.awssdk.services.appflow.model.FlowStatus.DELETED
  }
  case object Draft extends zio.aws.appflow.model.FlowStatus {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.FlowStatus =
      software.amazon.awssdk.services.appflow.model.FlowStatus.DRAFT
  }
  case object Errored extends zio.aws.appflow.model.FlowStatus {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.FlowStatus =
      software.amazon.awssdk.services.appflow.model.FlowStatus.ERRORED
  }
  case object Suspended extends zio.aws.appflow.model.FlowStatus {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.FlowStatus =
      software.amazon.awssdk.services.appflow.model.FlowStatus.SUSPENDED
  }
}
