package zio.aws.appflow.model
import scala.jdk.CollectionConverters.*
sealed trait GoogleAnalyticsConnectorOperator {
  def unwrap: software.amazon.awssdk.services.appflow.model.GoogleAnalyticsConnectorOperator
}
object GoogleAnalyticsConnectorOperator {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.GoogleAnalyticsConnectorOperator
  ): zio.aws.appflow.model.GoogleAnalyticsConnectorOperator = value match {
    case software.amazon.awssdk.services.appflow.model.GoogleAnalyticsConnectorOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.GoogleAnalyticsConnectorOperator.PROJECTION =>
      val r = PROJECTION
      r
    case software.amazon.awssdk.services.appflow.model.GoogleAnalyticsConnectorOperator.BETWEEN =>
      val r = BETWEEN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.GoogleAnalyticsConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.GoogleAnalyticsConnectorOperator =
      software.amazon.awssdk.services.appflow.model.GoogleAnalyticsConnectorOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object PROJECTION
      extends zio.aws.appflow.model.GoogleAnalyticsConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.GoogleAnalyticsConnectorOperator =
      software.amazon.awssdk.services.appflow.model.GoogleAnalyticsConnectorOperator.PROJECTION
  }
  case object BETWEEN
      extends zio.aws.appflow.model.GoogleAnalyticsConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.GoogleAnalyticsConnectorOperator =
      software.amazon.awssdk.services.appflow.model.GoogleAnalyticsConnectorOperator.BETWEEN
  }
}
