package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  ApiVersion,
  EntitiesPath,
  ConnectorProfileName
}
import scala.jdk.CollectionConverters.*
final case class ListConnectorEntitiesRequest(
    connectorProfileName: Optional[ConnectorProfileName] = Optional.Absent,
    connectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      Optional.Absent,
    entitiesPath: Optional[EntitiesPath] = Optional.Absent,
    apiVersion: Optional[ApiVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesRequest = {
    import ListConnectorEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesRequest
      .builder()
      .optionallyWith(
        connectorProfileName.map(value =>
          ConnectorProfileName.unwrap(value): java.lang.String
        )
      )(_.connectorProfileName)
      .optionallyWith(connectorType.map(value => value.unwrap))(_.connectorType)
      .optionallyWith(
        entitiesPath.map(value => EntitiesPath.unwrap(value): java.lang.String)
      )(_.entitiesPath)
      .optionallyWith(
        apiVersion.map(value => ApiVersion.unwrap(value): java.lang.String)
      )(_.apiVersion)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ListConnectorEntitiesRequest.ReadOnly =
    zio.aws.appflow.model.ListConnectorEntitiesRequest.wrap(buildAwsValue())
}
object ListConnectorEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ListConnectorEntitiesRequest =
      zio.aws.appflow.model.ListConnectorEntitiesRequest(
        connectorProfileName.map(value => value),
        connectorType.map(value => value),
        entitiesPath.map(value => value),
        apiVersion.map(value => value)
      )
    def connectorProfileName: Optional[ConnectorProfileName]
    def connectorType: Optional[zio.aws.appflow.model.ConnectorType]
    def entitiesPath: Optional[EntitiesPath]
    def apiVersion: Optional[ApiVersion]
    def getConnectorProfileName: ZIO[Any, AwsError, ConnectorProfileName] =
      AwsError.unwrapOptionField("connectorProfileName", connectorProfileName)
    def getConnectorType
        : ZIO[Any, AwsError, zio.aws.appflow.model.ConnectorType] =
      AwsError.unwrapOptionField("connectorType", connectorType)
    def getEntitiesPath: ZIO[Any, AwsError, EntitiesPath] =
      AwsError.unwrapOptionField("entitiesPath", entitiesPath)
    def getApiVersion: ZIO[Any, AwsError, ApiVersion] =
      AwsError.unwrapOptionField("apiVersion", apiVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesRequest
  ) extends zio.aws.appflow.model.ListConnectorEntitiesRequest.ReadOnly {
    override val connectorProfileName: Optional[ConnectorProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProfileName())
        .map(value =>
          zio.aws.appflow.model.primitives.ConnectorProfileName(value)
        )
    override val connectorType: Optional[zio.aws.appflow.model.ConnectorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorType())
        .map(value => zio.aws.appflow.model.ConnectorType.wrap(value))
    override val entitiesPath: Optional[EntitiesPath] = zio.aws.core.internal
      .optionalFromNullable(impl.entitiesPath())
      .map(value => zio.aws.appflow.model.primitives.EntitiesPath(value))
    override val apiVersion: Optional[ApiVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.apiVersion())
      .map(value => zio.aws.appflow.model.primitives.ApiVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ListConnectorEntitiesRequest
  ): zio.aws.appflow.model.ListConnectorEntitiesRequest.ReadOnly = new Wrapper(
    impl
  )
}
