package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.appflow.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ListTagsForResourceRequest =
      zio.aws.appflow.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ARN
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ListTagsForResourceRequest
  ) extends zio.aws.appflow.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.appflow.model.primitives.ARN(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ListTagsForResourceRequest
  ): zio.aws.appflow.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
