package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{AccessToken, ClientSecret, ClientId}
import scala.jdk.CollectionConverters.*
final case class MarketoConnectorProfileCredentials(
    clientId: ClientId,
    clientSecret: ClientSecret,
    accessToken: Optional[AccessToken] = Optional.Absent,
    oAuthRequest: Optional[zio.aws.appflow.model.ConnectorOAuthRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.MarketoConnectorProfileCredentials = {
    import MarketoConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.MarketoConnectorProfileCredentials
      .builder()
      .clientId(ClientId.unwrap(clientId): java.lang.String)
      .clientSecret(ClientSecret.unwrap(clientSecret): java.lang.String)
      .optionallyWith(
        accessToken.map(value => AccessToken.unwrap(value): java.lang.String)
      )(_.accessToken)
      .optionallyWith(oAuthRequest.map(value => value.buildAwsValue()))(
        _.oAuthRequest
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.MarketoConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.MarketoConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object MarketoConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.MarketoConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.MarketoConnectorProfileCredentials =
      zio.aws.appflow.model.MarketoConnectorProfileCredentials(
        clientId,
        clientSecret,
        accessToken.map(value => value),
        oAuthRequest.map(value => value.asEditable)
      )
    def clientId: ClientId
    def clientSecret: ClientSecret
    def accessToken: Optional[AccessToken]
    def oAuthRequest
        : Optional[zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly]
    def getClientId: ZIO[Any, Nothing, ClientId] = ZIO.succeed(clientId)
    def getClientSecret: ZIO[Any, Nothing, ClientSecret] =
      ZIO.succeed(clientSecret)
    def getAccessToken: ZIO[Any, AwsError, AccessToken] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getOAuthRequest: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly
    ] = AwsError.unwrapOptionField("oAuthRequest", oAuthRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.MarketoConnectorProfileCredentials
  ) extends zio.aws.appflow.model.MarketoConnectorProfileCredentials.ReadOnly {
    override val clientId: ClientId =
      zio.aws.appflow.model.primitives.ClientId(impl.clientId())
    override val clientSecret: ClientSecret =
      zio.aws.appflow.model.primitives.ClientSecret(impl.clientSecret())
    override val accessToken: Optional[AccessToken] = zio.aws.core.internal
      .optionalFromNullable(impl.accessToken())
      .map(value => zio.aws.appflow.model.primitives.AccessToken(value))
    override val oAuthRequest
        : Optional[zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oAuthRequest())
        .map(value => zio.aws.appflow.model.ConnectorOAuthRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.MarketoConnectorProfileCredentials
  ): zio.aws.appflow.model.MarketoConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
