package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.InstanceUrl
import scala.jdk.CollectionConverters.*
final case class MarketoConnectorProfileProperties(instanceUrl: InstanceUrl) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.MarketoConnectorProfileProperties = {
    import MarketoConnectorProfileProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.MarketoConnectorProfileProperties
      .builder()
      .instanceUrl(InstanceUrl.unwrap(instanceUrl): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.MarketoConnectorProfileProperties.ReadOnly =
    zio.aws.appflow.model.MarketoConnectorProfileProperties
      .wrap(buildAwsValue())
}
object MarketoConnectorProfileProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.MarketoConnectorProfileProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.MarketoConnectorProfileProperties =
      zio.aws.appflow.model.MarketoConnectorProfileProperties(instanceUrl)
    def instanceUrl: InstanceUrl
    def getInstanceUrl: ZIO[Any, Nothing, InstanceUrl] =
      ZIO.succeed(instanceUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.MarketoConnectorProfileProperties
  ) extends zio.aws.appflow.model.MarketoConnectorProfileProperties.ReadOnly {
    override val instanceUrl: InstanceUrl =
      zio.aws.appflow.model.primitives.InstanceUrl(impl.instanceUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.MarketoConnectorProfileProperties
  ): zio.aws.appflow.model.MarketoConnectorProfileProperties.ReadOnly =
    new Wrapper(impl)
}
