package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.Object
import scala.jdk.CollectionConverters.*
final case class MarketoDestinationProperties(
    `object`: Object,
    errorHandlingConfig: Optional[zio.aws.appflow.model.ErrorHandlingConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.MarketoDestinationProperties = {
    import MarketoDestinationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.MarketoDestinationProperties
      .builder()
      .`object`(Object.unwrap(`object`): java.lang.String)
      .optionallyWith(errorHandlingConfig.map(value => value.buildAwsValue()))(
        _.errorHandlingConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.MarketoDestinationProperties.ReadOnly =
    zio.aws.appflow.model.MarketoDestinationProperties.wrap(buildAwsValue())
}
object MarketoDestinationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.MarketoDestinationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.MarketoDestinationProperties =
      zio.aws.appflow.model.MarketoDestinationProperties(
        `object`,
        errorHandlingConfig.map(value => value.asEditable)
      )
    def `object`: Object
    def errorHandlingConfig
        : Optional[zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly]
    def getObject: ZIO[Any, Nothing, Object] = ZIO.succeed(`object`)
    def getErrorHandlingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("errorHandlingConfig", errorHandlingConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.MarketoDestinationProperties
  ) extends zio.aws.appflow.model.MarketoDestinationProperties.ReadOnly {
    override val `object`: Object =
      zio.aws.appflow.model.primitives.Object(impl.`object`())
    override val errorHandlingConfig
        : Optional[zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorHandlingConfig())
        .map(value => zio.aws.appflow.model.ErrorHandlingConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.MarketoDestinationProperties
  ): zio.aws.appflow.model.MarketoDestinationProperties.ReadOnly = new Wrapper(
    impl
  )
}
