package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  RefreshToken,
  AccessToken,
  ClientSecret,
  ClientId
}
import scala.jdk.CollectionConverters.*
final case class OAuth2Credentials(
    clientId: Optional[ClientId] = Optional.Absent,
    clientSecret: Optional[ClientSecret] = Optional.Absent,
    accessToken: Optional[AccessToken] = Optional.Absent,
    refreshToken: Optional[RefreshToken] = Optional.Absent,
    oAuthRequest: Optional[zio.aws.appflow.model.ConnectorOAuthRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.OAuth2Credentials = {
    import OAuth2Credentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.OAuth2Credentials
      .builder()
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        clientSecret.map(value => ClientSecret.unwrap(value): java.lang.String)
      )(_.clientSecret)
      .optionallyWith(
        accessToken.map(value => AccessToken.unwrap(value): java.lang.String)
      )(_.accessToken)
      .optionallyWith(
        refreshToken.map(value => RefreshToken.unwrap(value): java.lang.String)
      )(_.refreshToken)
      .optionallyWith(oAuthRequest.map(value => value.buildAwsValue()))(
        _.oAuthRequest
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.OAuth2Credentials.ReadOnly =
    zio.aws.appflow.model.OAuth2Credentials.wrap(buildAwsValue())
}
object OAuth2Credentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.OAuth2Credentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.OAuth2Credentials =
      zio.aws.appflow.model.OAuth2Credentials(
        clientId.map(value => value),
        clientSecret.map(value => value),
        accessToken.map(value => value),
        refreshToken.map(value => value),
        oAuthRequest.map(value => value.asEditable)
      )
    def clientId: Optional[ClientId]
    def clientSecret: Optional[ClientSecret]
    def accessToken: Optional[AccessToken]
    def refreshToken: Optional[RefreshToken]
    def oAuthRequest
        : Optional[zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly]
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getClientSecret: ZIO[Any, AwsError, ClientSecret] =
      AwsError.unwrapOptionField("clientSecret", clientSecret)
    def getAccessToken: ZIO[Any, AwsError, AccessToken] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getRefreshToken: ZIO[Any, AwsError, RefreshToken] =
      AwsError.unwrapOptionField("refreshToken", refreshToken)
    def getOAuthRequest: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly
    ] = AwsError.unwrapOptionField("oAuthRequest", oAuthRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.OAuth2Credentials
  ) extends zio.aws.appflow.model.OAuth2Credentials.ReadOnly {
    override val clientId: Optional[ClientId] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => zio.aws.appflow.model.primitives.ClientId(value))
    override val clientSecret: Optional[ClientSecret] = zio.aws.core.internal
      .optionalFromNullable(impl.clientSecret())
      .map(value => zio.aws.appflow.model.primitives.ClientSecret(value))
    override val accessToken: Optional[AccessToken] = zio.aws.core.internal
      .optionalFromNullable(impl.accessToken())
      .map(value => zio.aws.appflow.model.primitives.AccessToken(value))
    override val refreshToken: Optional[RefreshToken] = zio.aws.core.internal
      .optionalFromNullable(impl.refreshToken())
      .map(value => zio.aws.appflow.model.primitives.RefreshToken(value))
    override val oAuthRequest
        : Optional[zio.aws.appflow.model.ConnectorOAuthRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oAuthRequest())
        .map(value => zio.aws.appflow.model.ConnectorOAuthRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.OAuth2Credentials
  ): zio.aws.appflow.model.OAuth2Credentials.ReadOnly = new Wrapper(impl)
}
