package zio.aws.appflow.model
import scala.jdk.CollectionConverters.*
sealed trait OAuth2CustomPropType {
  def unwrap: software.amazon.awssdk.services.appflow.model.OAuth2CustomPropType
}
object OAuth2CustomPropType {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.OAuth2CustomPropType
  ): zio.aws.appflow.model.OAuth2CustomPropType = value match {
    case software.amazon.awssdk.services.appflow.model.OAuth2CustomPropType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.OAuth2CustomPropType.TOKEN_URL =>
      val r = TOKEN_URL
      r
    case software.amazon.awssdk.services.appflow.model.OAuth2CustomPropType.AUTH_URL =>
      val r = AUTH_URL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.OAuth2CustomPropType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.OAuth2CustomPropType =
      software.amazon.awssdk.services.appflow.model.OAuth2CustomPropType.UNKNOWN_TO_SDK_VERSION
  }
  case object TOKEN_URL extends zio.aws.appflow.model.OAuth2CustomPropType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.OAuth2CustomPropType =
      software.amazon.awssdk.services.appflow.model.OAuth2CustomPropType.TOKEN_URL
  }
  case object AUTH_URL extends zio.aws.appflow.model.OAuth2CustomPropType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.OAuth2CustomPropType =
      software.amazon.awssdk.services.appflow.model.OAuth2CustomPropType.AUTH_URL
  }
}
