package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{AuthCodeUrl, TokenUrl, OAuthScope}
import scala.jdk.CollectionConverters.*
final case class OAuth2Defaults(
    oauthScopes: Optional[Iterable[OAuthScope]] = Optional.Absent,
    tokenUrls: Optional[Iterable[TokenUrl]] = Optional.Absent,
    authCodeUrls: Optional[Iterable[AuthCodeUrl]] = Optional.Absent,
    oauth2GrantTypesSupported: Optional[
      Iterable[zio.aws.appflow.model.OAuth2GrantType]
    ] = Optional.Absent,
    oauth2CustomProperties: Optional[
      Iterable[zio.aws.appflow.model.OAuth2CustomParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.OAuth2Defaults = {
    import OAuth2Defaults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.OAuth2Defaults
      .builder()
      .optionallyWith(
        oauthScopes.map(value =>
          value.map { item =>
            OAuthScope.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.oauthScopes)
      .optionallyWith(
        tokenUrls.map(value =>
          value.map { item =>
            TokenUrl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tokenUrls)
      .optionallyWith(
        authCodeUrls.map(value =>
          value.map { item =>
            AuthCodeUrl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.authCodeUrls)
      .optionallyWith(
        oauth2GrantTypesSupported.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.oauth2GrantTypesSupportedWithStrings)
      .optionallyWith(
        oauth2CustomProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.oauth2CustomProperties)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.OAuth2Defaults.ReadOnly =
    zio.aws.appflow.model.OAuth2Defaults.wrap(buildAwsValue())
}
object OAuth2Defaults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.OAuth2Defaults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.OAuth2Defaults =
      zio.aws.appflow.model.OAuth2Defaults(
        oauthScopes.map(value => value),
        tokenUrls.map(value => value),
        authCodeUrls.map(value => value),
        oauth2GrantTypesSupported.map(value => value),
        oauth2CustomProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def oauthScopes: Optional[List[OAuthScope]]
    def tokenUrls: Optional[List[TokenUrl]]
    def authCodeUrls: Optional[List[AuthCodeUrl]]
    def oauth2GrantTypesSupported
        : Optional[List[zio.aws.appflow.model.OAuth2GrantType]]
    def oauth2CustomProperties
        : Optional[List[zio.aws.appflow.model.OAuth2CustomParameter.ReadOnly]]
    def getOauthScopes: ZIO[Any, AwsError, List[OAuthScope]] =
      AwsError.unwrapOptionField("oauthScopes", oauthScopes)
    def getTokenUrls: ZIO[Any, AwsError, List[TokenUrl]] =
      AwsError.unwrapOptionField("tokenUrls", tokenUrls)
    def getAuthCodeUrls: ZIO[Any, AwsError, List[AuthCodeUrl]] =
      AwsError.unwrapOptionField("authCodeUrls", authCodeUrls)
    def getOauth2GrantTypesSupported
        : ZIO[Any, AwsError, List[zio.aws.appflow.model.OAuth2GrantType]] =
      AwsError.unwrapOptionField(
        "oauth2GrantTypesSupported",
        oauth2GrantTypesSupported
      )
    def getOauth2CustomProperties: ZIO[Any, AwsError, List[
      zio.aws.appflow.model.OAuth2CustomParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "oauth2CustomProperties",
      oauth2CustomProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.OAuth2Defaults
  ) extends zio.aws.appflow.model.OAuth2Defaults.ReadOnly {
    override val oauthScopes: Optional[List[OAuthScope]] = zio.aws.core.internal
      .optionalFromNullable(impl.oauthScopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appflow.model.primitives.OAuthScope(item)
        }.toList
      )
    override val tokenUrls: Optional[List[TokenUrl]] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenUrls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appflow.model.primitives.TokenUrl(item)
        }.toList
      )
    override val authCodeUrls: Optional[List[AuthCodeUrl]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authCodeUrls())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.primitives.AuthCodeUrl(item)
          }.toList
        )
    override val oauth2GrantTypesSupported
        : Optional[List[zio.aws.appflow.model.OAuth2GrantType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oauth2GrantTypesSupported())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.OAuth2GrantType.wrap(item)
          }.toList
        )
    override val oauth2CustomProperties
        : Optional[List[zio.aws.appflow.model.OAuth2CustomParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oauth2CustomProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appflow.model.OAuth2CustomParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.OAuth2Defaults
  ): zio.aws.appflow.model.OAuth2Defaults.ReadOnly = new Wrapper(impl)
}
