package zio.aws.appflow.model
import scala.jdk.CollectionConverters.*
sealed trait OAuth2GrantType {
  def unwrap: software.amazon.awssdk.services.appflow.model.OAuth2GrantType
}
object OAuth2GrantType {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.OAuth2GrantType
  ): zio.aws.appflow.model.OAuth2GrantType = value match {
    case software.amazon.awssdk.services.appflow.model.OAuth2GrantType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.OAuth2GrantType.CLIENT_CREDENTIALS =>
      val r = CLIENT_CREDENTIALS
      r
    case software.amazon.awssdk.services.appflow.model.OAuth2GrantType.AUTHORIZATION_CODE =>
      val r = AUTHORIZATION_CODE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.OAuth2GrantType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.OAuth2GrantType =
      software.amazon.awssdk.services.appflow.model.OAuth2GrantType.UNKNOWN_TO_SDK_VERSION
  }
  case object CLIENT_CREDENTIALS extends zio.aws.appflow.model.OAuth2GrantType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.OAuth2GrantType =
      software.amazon.awssdk.services.appflow.model.OAuth2GrantType.CLIENT_CREDENTIALS
  }
  case object AUTHORIZATION_CODE extends zio.aws.appflow.model.OAuth2GrantType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.OAuth2GrantType =
      software.amazon.awssdk.services.appflow.model.OAuth2GrantType.AUTHORIZATION_CODE
  }
}
