package zio.aws.appflow.model
import scala.jdk.CollectionConverters.*
sealed trait PrefixType {
  def unwrap: software.amazon.awssdk.services.appflow.model.PrefixType
}
object PrefixType {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.PrefixType
  ): zio.aws.appflow.model.PrefixType = value match {
    case software.amazon.awssdk.services.appflow.model.PrefixType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.PrefixType.FILENAME =>
      val r = FILENAME
      r
    case software.amazon.awssdk.services.appflow.model.PrefixType.PATH =>
      val r = PATH
      r
    case software.amazon.awssdk.services.appflow.model.PrefixType.PATH_AND_FILENAME =>
      val r = PATH_AND_FILENAME
      r
  }
  case object unknownToSdkVersion extends zio.aws.appflow.model.PrefixType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.PrefixType =
      software.amazon.awssdk.services.appflow.model.PrefixType.UNKNOWN_TO_SDK_VERSION
  }
  case object FILENAME extends zio.aws.appflow.model.PrefixType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.PrefixType =
      software.amazon.awssdk.services.appflow.model.PrefixType.FILENAME
  }
  case object PATH extends zio.aws.appflow.model.PrefixType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.PrefixType =
      software.amazon.awssdk.services.appflow.model.PrefixType.PATH
  }
  case object PATH_AND_FILENAME extends zio.aws.appflow.model.PrefixType {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.PrefixType =
      software.amazon.awssdk.services.appflow.model.PrefixType.PATH_AND_FILENAME
  }
}
