package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Range(
    maximum: Optional[Double] = Optional.Absent,
    minimum: Optional[Double] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.appflow.model.Range = {
    import Range.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.Range
      .builder()
      .optionallyWith(maximum.map(value => value: java.lang.Double))(_.maximum)
      .optionallyWith(minimum.map(value => value: java.lang.Double))(_.minimum)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.Range.ReadOnly =
    zio.aws.appflow.model.Range.wrap(buildAwsValue())
}
object Range {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appflow.model.Range] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.Range = zio.aws.appflow.model
      .Range(maximum.map(value => value), minimum.map(value => value))
    def maximum: Optional[Double]
    def minimum: Optional[Double]
    def getMaximum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("maximum", maximum)
    def getMinimum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("minimum", minimum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.Range
  ) extends zio.aws.appflow.model.Range.ReadOnly {
    override val maximum: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.maximum())
      .map(value => value: Double)
    override val minimum: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.minimum())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.Range
  ): zio.aws.appflow.model.Range.ReadOnly = new Wrapper(impl)
}
