package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  RoleArn,
  BucketPrefix,
  BucketName,
  DatabaseUrl
}
import scala.jdk.CollectionConverters.*
final case class RedshiftConnectorProfileProperties(
    databaseUrl: DatabaseUrl,
    bucketName: BucketName,
    bucketPrefix: Optional[BucketPrefix] = Optional.Absent,
    roleArn: RoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.RedshiftConnectorProfileProperties = {
    import RedshiftConnectorProfileProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.RedshiftConnectorProfileProperties
      .builder()
      .databaseUrl(DatabaseUrl.unwrap(databaseUrl): java.lang.String)
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        bucketPrefix.map(value => BucketPrefix.unwrap(value): java.lang.String)
      )(_.bucketPrefix)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.RedshiftConnectorProfileProperties.ReadOnly =
    zio.aws.appflow.model.RedshiftConnectorProfileProperties
      .wrap(buildAwsValue())
}
object RedshiftConnectorProfileProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.RedshiftConnectorProfileProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.RedshiftConnectorProfileProperties =
      zio.aws.appflow.model.RedshiftConnectorProfileProperties(
        databaseUrl,
        bucketName,
        bucketPrefix.map(value => value),
        roleArn
      )
    def databaseUrl: DatabaseUrl
    def bucketName: BucketName
    def bucketPrefix: Optional[BucketPrefix]
    def roleArn: RoleArn
    def getDatabaseUrl: ZIO[Any, Nothing, DatabaseUrl] =
      ZIO.succeed(databaseUrl)
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getBucketPrefix: ZIO[Any, AwsError, BucketPrefix] =
      AwsError.unwrapOptionField("bucketPrefix", bucketPrefix)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.RedshiftConnectorProfileProperties
  ) extends zio.aws.appflow.model.RedshiftConnectorProfileProperties.ReadOnly {
    override val databaseUrl: DatabaseUrl =
      zio.aws.appflow.model.primitives.DatabaseUrl(impl.databaseUrl())
    override val bucketName: BucketName =
      zio.aws.appflow.model.primitives.BucketName(impl.bucketName())
    override val bucketPrefix: Optional[BucketPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketPrefix())
      .map(value => zio.aws.appflow.model.primitives.BucketPrefix(value))
    override val roleArn: RoleArn =
      zio.aws.appflow.model.primitives.RoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.RedshiftConnectorProfileProperties
  ): zio.aws.appflow.model.RedshiftConnectorProfileProperties.ReadOnly =
    new Wrapper(impl)
}
