package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{BucketPrefix, BucketName, Object}
import scala.jdk.CollectionConverters.*
final case class RedshiftDestinationProperties(
    `object`: Object,
    intermediateBucketName: BucketName,
    bucketPrefix: Optional[BucketPrefix] = Optional.Absent,
    errorHandlingConfig: Optional[zio.aws.appflow.model.ErrorHandlingConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.RedshiftDestinationProperties = {
    import RedshiftDestinationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.RedshiftDestinationProperties
      .builder()
      .`object`(Object.unwrap(`object`): java.lang.String)
      .intermediateBucketName(
        BucketName.unwrap(intermediateBucketName): java.lang.String
      )
      .optionallyWith(
        bucketPrefix.map(value => BucketPrefix.unwrap(value): java.lang.String)
      )(_.bucketPrefix)
      .optionallyWith(errorHandlingConfig.map(value => value.buildAwsValue()))(
        _.errorHandlingConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.RedshiftDestinationProperties.ReadOnly =
    zio.aws.appflow.model.RedshiftDestinationProperties.wrap(buildAwsValue())
}
object RedshiftDestinationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.RedshiftDestinationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.RedshiftDestinationProperties =
      zio.aws.appflow.model.RedshiftDestinationProperties(
        `object`,
        intermediateBucketName,
        bucketPrefix.map(value => value),
        errorHandlingConfig.map(value => value.asEditable)
      )
    def `object`: Object
    def intermediateBucketName: BucketName
    def bucketPrefix: Optional[BucketPrefix]
    def errorHandlingConfig
        : Optional[zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly]
    def getObject: ZIO[Any, Nothing, Object] = ZIO.succeed(`object`)
    def getIntermediateBucketName: ZIO[Any, Nothing, BucketName] =
      ZIO.succeed(intermediateBucketName)
    def getBucketPrefix: ZIO[Any, AwsError, BucketPrefix] =
      AwsError.unwrapOptionField("bucketPrefix", bucketPrefix)
    def getErrorHandlingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("errorHandlingConfig", errorHandlingConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.RedshiftDestinationProperties
  ) extends zio.aws.appflow.model.RedshiftDestinationProperties.ReadOnly {
    override val `object`: Object =
      zio.aws.appflow.model.primitives.Object(impl.`object`())
    override val intermediateBucketName: BucketName =
      zio.aws.appflow.model.primitives.BucketName(impl.intermediateBucketName())
    override val bucketPrefix: Optional[BucketPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketPrefix())
      .map(value => zio.aws.appflow.model.primitives.BucketPrefix(value))
    override val errorHandlingConfig
        : Optional[zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorHandlingConfig())
        .map(value => zio.aws.appflow.model.ErrorHandlingConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.RedshiftDestinationProperties
  ): zio.aws.appflow.model.RedshiftDestinationProperties.ReadOnly = new Wrapper(
    impl
  )
}
