package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{BucketPrefix, BucketName}
import scala.jdk.CollectionConverters.*
final case class S3DestinationProperties(
    bucketName: BucketName,
    bucketPrefix: Optional[BucketPrefix] = Optional.Absent,
    s3OutputFormatConfig: Optional[zio.aws.appflow.model.S3OutputFormatConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.S3DestinationProperties = {
    import S3DestinationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.S3DestinationProperties
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        bucketPrefix.map(value => BucketPrefix.unwrap(value): java.lang.String)
      )(_.bucketPrefix)
      .optionallyWith(s3OutputFormatConfig.map(value => value.buildAwsValue()))(
        _.s3OutputFormatConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.S3DestinationProperties.ReadOnly =
    zio.aws.appflow.model.S3DestinationProperties.wrap(buildAwsValue())
}
object S3DestinationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.S3DestinationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.S3DestinationProperties =
      zio.aws.appflow.model.S3DestinationProperties(
        bucketName,
        bucketPrefix.map(value => value),
        s3OutputFormatConfig.map(value => value.asEditable)
      )
    def bucketName: BucketName
    def bucketPrefix: Optional[BucketPrefix]
    def s3OutputFormatConfig
        : Optional[zio.aws.appflow.model.S3OutputFormatConfig.ReadOnly]
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getBucketPrefix: ZIO[Any, AwsError, BucketPrefix] =
      AwsError.unwrapOptionField("bucketPrefix", bucketPrefix)
    def getS3OutputFormatConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.S3OutputFormatConfig.ReadOnly
    ] = AwsError.unwrapOptionField("s3OutputFormatConfig", s3OutputFormatConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.S3DestinationProperties
  ) extends zio.aws.appflow.model.S3DestinationProperties.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.appflow.model.primitives.BucketName(impl.bucketName())
    override val bucketPrefix: Optional[BucketPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketPrefix())
      .map(value => zio.aws.appflow.model.primitives.BucketPrefix(value))
    override val s3OutputFormatConfig
        : Optional[zio.aws.appflow.model.S3OutputFormatConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3OutputFormatConfig())
        .map(value => zio.aws.appflow.model.S3OutputFormatConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.S3DestinationProperties
  ): zio.aws.appflow.model.S3DestinationProperties.ReadOnly = new Wrapper(impl)
}
