package zio.aws.appflow.model
import scala.jdk.CollectionConverters.*
sealed trait SAPODataConnectorOperator {
  def unwrap
      : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator
}
object SAPODataConnectorOperator {
  def wrap(
      value: software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator
  ): zio.aws.appflow.model.SAPODataConnectorOperator = value match {
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.PROJECTION =>
      val r = PROJECTION
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.LESS_THAN =>
      val r = LESS_THAN
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.CONTAINS =>
      val r = CONTAINS
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.GREATER_THAN =>
      val r = GREATER_THAN
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.BETWEEN =>
      val r = BETWEEN
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.LESS_THAN_OR_EQUAL_TO =>
      val r = LESS_THAN_OR_EQUAL_TO
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.GREATER_THAN_OR_EQUAL_TO =>
      val r = GREATER_THAN_OR_EQUAL_TO
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.EQUAL_TO =>
      val r = EQUAL_TO
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.NOT_EQUAL_TO =>
      val r = NOT_EQUAL_TO
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.ADDITION =>
      val r = ADDITION
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.MULTIPLICATION =>
      val r = MULTIPLICATION
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.DIVISION =>
      val r = DIVISION
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.SUBTRACTION =>
      val r = SUBTRACTION
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.MASK_ALL =>
      val r = MASK_ALL
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.MASK_FIRST_N =>
      val r = MASK_FIRST_N
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.MASK_LAST_N =>
      val r = MASK_LAST_N
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.VALIDATE_NON_NULL =>
      val r = VALIDATE_NON_NULL
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.VALIDATE_NON_ZERO =>
      val r = VALIDATE_NON_ZERO
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.VALIDATE_NON_NEGATIVE =>
      val r = VALIDATE_NON_NEGATIVE
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.VALIDATE_NUMERIC =>
      val r = VALIDATE_NUMERIC
      r
    case software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.NO_OP =>
      val r = NO_OP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object PROJECTION
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.PROJECTION
  }
  case object LESS_THAN
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.LESS_THAN
  }
  case object CONTAINS extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.CONTAINS
  }
  case object GREATER_THAN
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.GREATER_THAN
  }
  case object BETWEEN extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.BETWEEN
  }
  case object LESS_THAN_OR_EQUAL_TO
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.LESS_THAN_OR_EQUAL_TO
  }
  case object GREATER_THAN_OR_EQUAL_TO
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.GREATER_THAN_OR_EQUAL_TO
  }
  case object EQUAL_TO extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.EQUAL_TO
  }
  case object NOT_EQUAL_TO
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.NOT_EQUAL_TO
  }
  case object ADDITION extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.ADDITION
  }
  case object MULTIPLICATION
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.MULTIPLICATION
  }
  case object DIVISION extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.DIVISION
  }
  case object SUBTRACTION
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.SUBTRACTION
  }
  case object MASK_ALL extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.MASK_ALL
  }
  case object MASK_FIRST_N
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.MASK_FIRST_N
  }
  case object MASK_LAST_N
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.MASK_LAST_N
  }
  case object VALIDATE_NON_NULL
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.VALIDATE_NON_NULL
  }
  case object VALIDATE_NON_ZERO
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.VALIDATE_NON_ZERO
  }
  case object VALIDATE_NON_NEGATIVE
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.VALIDATE_NON_NEGATIVE
  }
  case object VALIDATE_NUMERIC
      extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.VALIDATE_NUMERIC
  }
  case object NO_OP extends zio.aws.appflow.model.SAPODataConnectorOperator {
    override def unwrap
        : software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator =
      software.amazon.awssdk.services.appflow.model.SAPODataConnectorOperator.NO_OP
  }
}
