package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SAPODataConnectorProfileCredentials(
    basicAuthCredentials: Optional[zio.aws.appflow.model.BasicAuthCredentials] =
      Optional.Absent,
    oAuthCredentials: Optional[zio.aws.appflow.model.OAuthCredentials] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SAPODataConnectorProfileCredentials = {
    import SAPODataConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SAPODataConnectorProfileCredentials
      .builder()
      .optionallyWith(basicAuthCredentials.map(value => value.buildAwsValue()))(
        _.basicAuthCredentials
      )
      .optionallyWith(oAuthCredentials.map(value => value.buildAwsValue()))(
        _.oAuthCredentials
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.SAPODataConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.SAPODataConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object SAPODataConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SAPODataConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SAPODataConnectorProfileCredentials =
      zio.aws.appflow.model.SAPODataConnectorProfileCredentials(
        basicAuthCredentials.map(value => value.asEditable),
        oAuthCredentials.map(value => value.asEditable)
      )
    def basicAuthCredentials
        : Optional[zio.aws.appflow.model.BasicAuthCredentials.ReadOnly]
    def oAuthCredentials
        : Optional[zio.aws.appflow.model.OAuthCredentials.ReadOnly]
    def getBasicAuthCredentials: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.BasicAuthCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("basicAuthCredentials", basicAuthCredentials)
    def getOAuthCredentials
        : ZIO[Any, AwsError, zio.aws.appflow.model.OAuthCredentials.ReadOnly] =
      AwsError.unwrapOptionField("oAuthCredentials", oAuthCredentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SAPODataConnectorProfileCredentials
  ) extends zio.aws.appflow.model.SAPODataConnectorProfileCredentials.ReadOnly {
    override val basicAuthCredentials
        : Optional[zio.aws.appflow.model.BasicAuthCredentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.basicAuthCredentials())
        .map(value => zio.aws.appflow.model.BasicAuthCredentials.wrap(value))
    override val oAuthCredentials
        : Optional[zio.aws.appflow.model.OAuthCredentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oAuthCredentials())
        .map(value => zio.aws.appflow.model.OAuthCredentials.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SAPODataConnectorProfileCredentials
  ): zio.aws.appflow.model.SAPODataConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
