package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{Name, Object}
import scala.jdk.CollectionConverters.*
final case class SalesforceDestinationProperties(
    `object`: Object,
    idFieldNames: Optional[Iterable[Name]] = Optional.Absent,
    errorHandlingConfig: Optional[zio.aws.appflow.model.ErrorHandlingConfig] =
      Optional.Absent,
    writeOperationType: Optional[zio.aws.appflow.model.WriteOperationType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SalesforceDestinationProperties = {
    import SalesforceDestinationProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SalesforceDestinationProperties
      .builder()
      .`object`(Object.unwrap(`object`): java.lang.String)
      .optionallyWith(
        idFieldNames.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.idFieldNames)
      .optionallyWith(errorHandlingConfig.map(value => value.buildAwsValue()))(
        _.errorHandlingConfig
      )
      .optionallyWith(writeOperationType.map(value => value.unwrap))(
        _.writeOperationType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.SalesforceDestinationProperties.ReadOnly =
    zio.aws.appflow.model.SalesforceDestinationProperties.wrap(buildAwsValue())
}
object SalesforceDestinationProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SalesforceDestinationProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SalesforceDestinationProperties =
      zio.aws.appflow.model.SalesforceDestinationProperties(
        `object`,
        idFieldNames.map(value => value),
        errorHandlingConfig.map(value => value.asEditable),
        writeOperationType.map(value => value)
      )
    def `object`: Object
    def idFieldNames: Optional[List[Name]]
    def errorHandlingConfig
        : Optional[zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly]
    def writeOperationType: Optional[zio.aws.appflow.model.WriteOperationType]
    def getObject: ZIO[Any, Nothing, Object] = ZIO.succeed(`object`)
    def getIdFieldNames: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("idFieldNames", idFieldNames)
    def getErrorHandlingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("errorHandlingConfig", errorHandlingConfig)
    def getWriteOperationType
        : ZIO[Any, AwsError, zio.aws.appflow.model.WriteOperationType] =
      AwsError.unwrapOptionField("writeOperationType", writeOperationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SalesforceDestinationProperties
  ) extends zio.aws.appflow.model.SalesforceDestinationProperties.ReadOnly {
    override val `object`: Object =
      zio.aws.appflow.model.primitives.Object(impl.`object`())
    override val idFieldNames: Optional[List[Name]] = zio.aws.core.internal
      .optionalFromNullable(impl.idFieldNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appflow.model.primitives.Name(item)
        }.toList
      )
    override val errorHandlingConfig
        : Optional[zio.aws.appflow.model.ErrorHandlingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorHandlingConfig())
        .map(value => zio.aws.appflow.model.ErrorHandlingConfig.wrap(value))
    override val writeOperationType
        : Optional[zio.aws.appflow.model.WriteOperationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeOperationType())
        .map(value => zio.aws.appflow.model.WriteOperationType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SalesforceDestinationProperties
  ): zio.aws.appflow.model.SalesforceDestinationProperties.ReadOnly =
    new Wrapper(impl)
}
