package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.OAuthScope
import scala.jdk.CollectionConverters.*
final case class SalesforceMetadata(
    oAuthScopes: Optional[Iterable[OAuthScope]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SalesforceMetadata = {
    import SalesforceMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SalesforceMetadata
      .builder()
      .optionallyWith(
        oAuthScopes.map(value =>
          value.map { item =>
            OAuthScope.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.oAuthScopes)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.SalesforceMetadata.ReadOnly =
    zio.aws.appflow.model.SalesforceMetadata.wrap(buildAwsValue())
}
object SalesforceMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SalesforceMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SalesforceMetadata =
      zio.aws.appflow.model.SalesforceMetadata(oAuthScopes.map(value => value))
    def oAuthScopes: Optional[List[OAuthScope]]
    def getOAuthScopes: ZIO[Any, AwsError, List[OAuthScope]] =
      AwsError.unwrapOptionField("oAuthScopes", oAuthScopes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SalesforceMetadata
  ) extends zio.aws.appflow.model.SalesforceMetadata.ReadOnly {
    override val oAuthScopes: Optional[List[OAuthScope]] = zio.aws.core.internal
      .optionalFromNullable(impl.oAuthScopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appflow.model.primitives.OAuthScope(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SalesforceMetadata
  ): zio.aws.appflow.model.SalesforceMetadata.ReadOnly = new Wrapper(impl)
}
