package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.InstanceUrl
import scala.jdk.CollectionConverters.*
final case class ServiceNowConnectorProfileProperties(
    instanceUrl: InstanceUrl
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.ServiceNowConnectorProfileProperties = {
    import ServiceNowConnectorProfileProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.ServiceNowConnectorProfileProperties
      .builder()
      .instanceUrl(InstanceUrl.unwrap(instanceUrl): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.ServiceNowConnectorProfileProperties.ReadOnly =
    zio.aws.appflow.model.ServiceNowConnectorProfileProperties
      .wrap(buildAwsValue())
}
object ServiceNowConnectorProfileProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.ServiceNowConnectorProfileProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.ServiceNowConnectorProfileProperties =
      zio.aws.appflow.model.ServiceNowConnectorProfileProperties(instanceUrl)
    def instanceUrl: InstanceUrl
    def getInstanceUrl: ZIO[Any, Nothing, InstanceUrl] =
      ZIO.succeed(instanceUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.ServiceNowConnectorProfileProperties
  ) extends zio.aws.appflow.model.ServiceNowConnectorProfileProperties.ReadOnly {
    override val instanceUrl: InstanceUrl =
      zio.aws.appflow.model.primitives.InstanceUrl(impl.instanceUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.ServiceNowConnectorProfileProperties
  ): zio.aws.appflow.model.ServiceNowConnectorProfileProperties.ReadOnly =
    new Wrapper(impl)
}
