package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appflow.model.primitives.ApiKey
import scala.jdk.CollectionConverters.*
final case class SingularConnectorProfileCredentials(apiKey: ApiKey) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SingularConnectorProfileCredentials = {
    import SingularConnectorProfileCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SingularConnectorProfileCredentials
      .builder()
      .apiKey(ApiKey.unwrap(apiKey): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.SingularConnectorProfileCredentials.ReadOnly =
    zio.aws.appflow.model.SingularConnectorProfileCredentials
      .wrap(buildAwsValue())
}
object SingularConnectorProfileCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SingularConnectorProfileCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SingularConnectorProfileCredentials =
      zio.aws.appflow.model.SingularConnectorProfileCredentials(apiKey)
    def apiKey: ApiKey
    def getApiKey: ZIO[Any, Nothing, ApiKey] = ZIO.succeed(apiKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SingularConnectorProfileCredentials
  ) extends zio.aws.appflow.model.SingularConnectorProfileCredentials.ReadOnly {
    override val apiKey: ApiKey =
      zio.aws.appflow.model.primitives.ApiKey(impl.apiKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SingularConnectorProfileCredentials
  ): zio.aws.appflow.model.SingularConnectorProfileCredentials.ReadOnly =
    new Wrapper(impl)
}
