package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.OAuthScope
import scala.jdk.CollectionConverters.*
final case class SlackMetadata(
    oAuthScopes: Optional[Iterable[OAuthScope]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SlackMetadata = {
    import SlackMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SlackMetadata
      .builder()
      .optionallyWith(
        oAuthScopes.map(value =>
          value.map { item =>
            OAuthScope.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.oAuthScopes)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.SlackMetadata.ReadOnly =
    zio.aws.appflow.model.SlackMetadata.wrap(buildAwsValue())
}
object SlackMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SlackMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SlackMetadata =
      zio.aws.appflow.model.SlackMetadata(oAuthScopes.map(value => value))
    def oAuthScopes: Optional[List[OAuthScope]]
    def getOAuthScopes: ZIO[Any, AwsError, List[OAuthScope]] =
      AwsError.unwrapOptionField("oAuthScopes", oAuthScopes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SlackMetadata
  ) extends zio.aws.appflow.model.SlackMetadata.ReadOnly {
    override val oAuthScopes: Optional[List[OAuthScope]] = zio.aws.core.internal
      .optionalFromNullable(impl.oAuthScopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appflow.model.primitives.OAuthScope(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SlackMetadata
  ): zio.aws.appflow.model.SlackMetadata.ReadOnly = new Wrapper(impl)
}
