package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{
  Stage,
  Warehouse,
  BucketPrefix,
  PrivateLinkServiceName,
  Region,
  BucketName,
  AccountName
}
import scala.jdk.CollectionConverters.*
final case class SnowflakeConnectorProfileProperties(
    warehouse: Warehouse,
    stage: Stage,
    bucketName: BucketName,
    bucketPrefix: Optional[BucketPrefix] = Optional.Absent,
    privateLinkServiceName: Optional[PrivateLinkServiceName] = Optional.Absent,
    accountName: Optional[AccountName] = Optional.Absent,
    region: Optional[Region] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SnowflakeConnectorProfileProperties = {
    import SnowflakeConnectorProfileProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SnowflakeConnectorProfileProperties
      .builder()
      .warehouse(Warehouse.unwrap(warehouse): java.lang.String)
      .stage(Stage.unwrap(stage): java.lang.String)
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        bucketPrefix.map(value => BucketPrefix.unwrap(value): java.lang.String)
      )(_.bucketPrefix)
      .optionallyWith(
        privateLinkServiceName.map(value =>
          PrivateLinkServiceName.unwrap(value): java.lang.String
        )
      )(_.privateLinkServiceName)
      .optionallyWith(
        accountName.map(value => AccountName.unwrap(value): java.lang.String)
      )(_.accountName)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly
      : zio.aws.appflow.model.SnowflakeConnectorProfileProperties.ReadOnly =
    zio.aws.appflow.model.SnowflakeConnectorProfileProperties
      .wrap(buildAwsValue())
}
object SnowflakeConnectorProfileProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SnowflakeConnectorProfileProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SnowflakeConnectorProfileProperties =
      zio.aws.appflow.model.SnowflakeConnectorProfileProperties(
        warehouse,
        stage,
        bucketName,
        bucketPrefix.map(value => value),
        privateLinkServiceName.map(value => value),
        accountName.map(value => value),
        region.map(value => value)
      )
    def warehouse: Warehouse
    def stage: Stage
    def bucketName: BucketName
    def bucketPrefix: Optional[BucketPrefix]
    def privateLinkServiceName: Optional[PrivateLinkServiceName]
    def accountName: Optional[AccountName]
    def region: Optional[Region]
    def getWarehouse: ZIO[Any, Nothing, Warehouse] = ZIO.succeed(warehouse)
    def getStage: ZIO[Any, Nothing, Stage] = ZIO.succeed(stage)
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getBucketPrefix: ZIO[Any, AwsError, BucketPrefix] =
      AwsError.unwrapOptionField("bucketPrefix", bucketPrefix)
    def getPrivateLinkServiceName: ZIO[Any, AwsError, PrivateLinkServiceName] =
      AwsError.unwrapOptionField(
        "privateLinkServiceName",
        privateLinkServiceName
      )
    def getAccountName: ZIO[Any, AwsError, AccountName] =
      AwsError.unwrapOptionField("accountName", accountName)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SnowflakeConnectorProfileProperties
  ) extends zio.aws.appflow.model.SnowflakeConnectorProfileProperties.ReadOnly {
    override val warehouse: Warehouse =
      zio.aws.appflow.model.primitives.Warehouse(impl.warehouse())
    override val stage: Stage =
      zio.aws.appflow.model.primitives.Stage(impl.stage())
    override val bucketName: BucketName =
      zio.aws.appflow.model.primitives.BucketName(impl.bucketName())
    override val bucketPrefix: Optional[BucketPrefix] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketPrefix())
      .map(value => zio.aws.appflow.model.primitives.BucketPrefix(value))
    override val privateLinkServiceName: Optional[PrivateLinkServiceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateLinkServiceName())
        .map(value =>
          zio.aws.appflow.model.primitives.PrivateLinkServiceName(value)
        )
    override val accountName: Optional[AccountName] = zio.aws.core.internal
      .optionalFromNullable(impl.accountName())
      .map(value => zio.aws.appflow.model.primitives.AccountName(value))
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.appflow.model.primitives.Region(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SnowflakeConnectorProfileProperties
  ): zio.aws.appflow.model.SnowflakeConnectorProfileProperties.ReadOnly =
    new Wrapper(impl)
}
