package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceConnectorProperties(
    amplitude: Optional[zio.aws.appflow.model.AmplitudeSourceProperties] =
      Optional.Absent,
    datadog: Optional[zio.aws.appflow.model.DatadogSourceProperties] =
      Optional.Absent,
    dynatrace: Optional[zio.aws.appflow.model.DynatraceSourceProperties] =
      Optional.Absent,
    googleAnalytics: Optional[
      zio.aws.appflow.model.GoogleAnalyticsSourceProperties
    ] = Optional.Absent,
    inforNexus: Optional[zio.aws.appflow.model.InforNexusSourceProperties] =
      Optional.Absent,
    marketo: Optional[zio.aws.appflow.model.MarketoSourceProperties] =
      Optional.Absent,
    s3: Optional[zio.aws.appflow.model.S3SourceProperties] = Optional.Absent,
    salesforce: Optional[zio.aws.appflow.model.SalesforceSourceProperties] =
      Optional.Absent,
    serviceNow: Optional[zio.aws.appflow.model.ServiceNowSourceProperties] =
      Optional.Absent,
    singular: Optional[zio.aws.appflow.model.SingularSourceProperties] =
      Optional.Absent,
    slack: Optional[zio.aws.appflow.model.SlackSourceProperties] =
      Optional.Absent,
    trendmicro: Optional[zio.aws.appflow.model.TrendmicroSourceProperties] =
      Optional.Absent,
    veeva: Optional[zio.aws.appflow.model.VeevaSourceProperties] =
      Optional.Absent,
    zendesk: Optional[zio.aws.appflow.model.ZendeskSourceProperties] =
      Optional.Absent,
    sapoData: Optional[zio.aws.appflow.model.SAPODataSourceProperties] =
      Optional.Absent,
    customConnector: Optional[
      zio.aws.appflow.model.CustomConnectorSourceProperties
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SourceConnectorProperties = {
    import SourceConnectorProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SourceConnectorProperties
      .builder()
      .optionallyWith(amplitude.map(value => value.buildAwsValue()))(
        _.amplitude
      )
      .optionallyWith(datadog.map(value => value.buildAwsValue()))(_.datadog)
      .optionallyWith(dynatrace.map(value => value.buildAwsValue()))(
        _.dynatrace
      )
      .optionallyWith(googleAnalytics.map(value => value.buildAwsValue()))(
        _.googleAnalytics
      )
      .optionallyWith(inforNexus.map(value => value.buildAwsValue()))(
        _.inforNexus
      )
      .optionallyWith(marketo.map(value => value.buildAwsValue()))(_.marketo)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .optionallyWith(salesforce.map(value => value.buildAwsValue()))(
        _.salesforce
      )
      .optionallyWith(serviceNow.map(value => value.buildAwsValue()))(
        _.serviceNow
      )
      .optionallyWith(singular.map(value => value.buildAwsValue()))(_.singular)
      .optionallyWith(slack.map(value => value.buildAwsValue()))(_.slack)
      .optionallyWith(trendmicro.map(value => value.buildAwsValue()))(
        _.trendmicro
      )
      .optionallyWith(veeva.map(value => value.buildAwsValue()))(_.veeva)
      .optionallyWith(zendesk.map(value => value.buildAwsValue()))(_.zendesk)
      .optionallyWith(sapoData.map(value => value.buildAwsValue()))(_.sapoData)
      .optionallyWith(customConnector.map(value => value.buildAwsValue()))(
        _.customConnector
      )
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.SourceConnectorProperties.ReadOnly =
    zio.aws.appflow.model.SourceConnectorProperties.wrap(buildAwsValue())
}
object SourceConnectorProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SourceConnectorProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SourceConnectorProperties =
      zio.aws.appflow.model.SourceConnectorProperties(
        amplitude.map(value => value.asEditable),
        datadog.map(value => value.asEditable),
        dynatrace.map(value => value.asEditable),
        googleAnalytics.map(value => value.asEditable),
        inforNexus.map(value => value.asEditable),
        marketo.map(value => value.asEditable),
        s3.map(value => value.asEditable),
        salesforce.map(value => value.asEditable),
        serviceNow.map(value => value.asEditable),
        singular.map(value => value.asEditable),
        slack.map(value => value.asEditable),
        trendmicro.map(value => value.asEditable),
        veeva.map(value => value.asEditable),
        zendesk.map(value => value.asEditable),
        sapoData.map(value => value.asEditable),
        customConnector.map(value => value.asEditable)
      )
    def amplitude
        : Optional[zio.aws.appflow.model.AmplitudeSourceProperties.ReadOnly]
    def datadog
        : Optional[zio.aws.appflow.model.DatadogSourceProperties.ReadOnly]
    def dynatrace
        : Optional[zio.aws.appflow.model.DynatraceSourceProperties.ReadOnly]
    def googleAnalytics: Optional[
      zio.aws.appflow.model.GoogleAnalyticsSourceProperties.ReadOnly
    ]
    def inforNexus
        : Optional[zio.aws.appflow.model.InforNexusSourceProperties.ReadOnly]
    def marketo
        : Optional[zio.aws.appflow.model.MarketoSourceProperties.ReadOnly]
    def s3: Optional[zio.aws.appflow.model.S3SourceProperties.ReadOnly]
    def salesforce
        : Optional[zio.aws.appflow.model.SalesforceSourceProperties.ReadOnly]
    def serviceNow
        : Optional[zio.aws.appflow.model.ServiceNowSourceProperties.ReadOnly]
    def singular
        : Optional[zio.aws.appflow.model.SingularSourceProperties.ReadOnly]
    def slack: Optional[zio.aws.appflow.model.SlackSourceProperties.ReadOnly]
    def trendmicro
        : Optional[zio.aws.appflow.model.TrendmicroSourceProperties.ReadOnly]
    def veeva: Optional[zio.aws.appflow.model.VeevaSourceProperties.ReadOnly]
    def zendesk
        : Optional[zio.aws.appflow.model.ZendeskSourceProperties.ReadOnly]
    def sapoData
        : Optional[zio.aws.appflow.model.SAPODataSourceProperties.ReadOnly]
    def customConnector: Optional[
      zio.aws.appflow.model.CustomConnectorSourceProperties.ReadOnly
    ]
    def getAmplitude: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.AmplitudeSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("amplitude", amplitude)
    def getDatadog: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.DatadogSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("datadog", datadog)
    def getDynatrace: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.DynatraceSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("dynatrace", dynatrace)
    def getGoogleAnalytics: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.GoogleAnalyticsSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("googleAnalytics", googleAnalytics)
    def getInforNexus: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.InforNexusSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("inforNexus", inforNexus)
    def getMarketo: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.MarketoSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("marketo", marketo)
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.S3SourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
    def getSalesforce: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SalesforceSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("salesforce", salesforce)
    def getServiceNow: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ServiceNowSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("serviceNow", serviceNow)
    def getSingular: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SingularSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("singular", singular)
    def getSlack: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SlackSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("slack", slack)
    def getTrendmicro: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.TrendmicroSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("trendmicro", trendmicro)
    def getVeeva: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.VeevaSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("veeva", veeva)
    def getZendesk: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.ZendeskSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("zendesk", zendesk)
    def getSapoData: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.SAPODataSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("sapoData", sapoData)
    def getCustomConnector: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.CustomConnectorSourceProperties.ReadOnly
    ] = AwsError.unwrapOptionField("customConnector", customConnector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SourceConnectorProperties
  ) extends zio.aws.appflow.model.SourceConnectorProperties.ReadOnly {
    override val amplitude
        : Optional[zio.aws.appflow.model.AmplitudeSourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amplitude())
        .map(value =>
          zio.aws.appflow.model.AmplitudeSourceProperties.wrap(value)
        )
    override val datadog
        : Optional[zio.aws.appflow.model.DatadogSourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datadog())
        .map(value => zio.aws.appflow.model.DatadogSourceProperties.wrap(value))
    override val dynatrace
        : Optional[zio.aws.appflow.model.DynatraceSourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dynatrace())
        .map(value =>
          zio.aws.appflow.model.DynatraceSourceProperties.wrap(value)
        )
    override val googleAnalytics: Optional[
      zio.aws.appflow.model.GoogleAnalyticsSourceProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.googleAnalytics())
      .map(value =>
        zio.aws.appflow.model.GoogleAnalyticsSourceProperties.wrap(value)
      )
    override val inforNexus
        : Optional[zio.aws.appflow.model.InforNexusSourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inforNexus())
        .map(value =>
          zio.aws.appflow.model.InforNexusSourceProperties.wrap(value)
        )
    override val marketo
        : Optional[zio.aws.appflow.model.MarketoSourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.marketo())
        .map(value => zio.aws.appflow.model.MarketoSourceProperties.wrap(value))
    override val s3
        : Optional[zio.aws.appflow.model.S3SourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value => zio.aws.appflow.model.S3SourceProperties.wrap(value))
    override val salesforce
        : Optional[zio.aws.appflow.model.SalesforceSourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.salesforce())
        .map(value =>
          zio.aws.appflow.model.SalesforceSourceProperties.wrap(value)
        )
    override val serviceNow
        : Optional[zio.aws.appflow.model.ServiceNowSourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceNow())
        .map(value =>
          zio.aws.appflow.model.ServiceNowSourceProperties.wrap(value)
        )
    override val singular
        : Optional[zio.aws.appflow.model.SingularSourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singular())
        .map(value =>
          zio.aws.appflow.model.SingularSourceProperties.wrap(value)
        )
    override val slack
        : Optional[zio.aws.appflow.model.SlackSourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slack())
        .map(value => zio.aws.appflow.model.SlackSourceProperties.wrap(value))
    override val trendmicro
        : Optional[zio.aws.appflow.model.TrendmicroSourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trendmicro())
        .map(value =>
          zio.aws.appflow.model.TrendmicroSourceProperties.wrap(value)
        )
    override val veeva
        : Optional[zio.aws.appflow.model.VeevaSourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.veeva())
        .map(value => zio.aws.appflow.model.VeevaSourceProperties.wrap(value))
    override val zendesk
        : Optional[zio.aws.appflow.model.ZendeskSourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.zendesk())
        .map(value => zio.aws.appflow.model.ZendeskSourceProperties.wrap(value))
    override val sapoData
        : Optional[zio.aws.appflow.model.SAPODataSourceProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sapoData())
        .map(value =>
          zio.aws.appflow.model.SAPODataSourceProperties.wrap(value)
        )
    override val customConnector: Optional[
      zio.aws.appflow.model.CustomConnectorSourceProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customConnector())
      .map(value =>
        zio.aws.appflow.model.CustomConnectorSourceProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SourceConnectorProperties
  ): zio.aws.appflow.model.SourceConnectorProperties.ReadOnly = new Wrapper(
    impl
  )
}
