package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceFieldProperties(
    isRetrievable: Optional[Boolean] = Optional.Absent,
    isQueryable: Optional[Boolean] = Optional.Absent,
    isTimestampFieldForIncrementalQueries: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SourceFieldProperties = {
    import SourceFieldProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SourceFieldProperties
      .builder()
      .optionallyWith(isRetrievable.map(value => value: java.lang.Boolean))(
        _.isRetrievable
      )
      .optionallyWith(isQueryable.map(value => value: java.lang.Boolean))(
        _.isQueryable
      )
      .optionallyWith(
        isTimestampFieldForIncrementalQueries.map(value =>
          value: java.lang.Boolean
        )
      )(_.isTimestampFieldForIncrementalQueries)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.SourceFieldProperties.ReadOnly =
    zio.aws.appflow.model.SourceFieldProperties.wrap(buildAwsValue())
}
object SourceFieldProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SourceFieldProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SourceFieldProperties =
      zio.aws.appflow.model.SourceFieldProperties(
        isRetrievable.map(value => value),
        isQueryable.map(value => value),
        isTimestampFieldForIncrementalQueries.map(value => value)
      )
    def isRetrievable: Optional[Boolean]
    def isQueryable: Optional[Boolean]
    def isTimestampFieldForIncrementalQueries: Optional[Boolean]
    def getIsRetrievable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRetrievable", isRetrievable)
    def getIsQueryable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isQueryable", isQueryable)
    def getIsTimestampFieldForIncrementalQueries: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "isTimestampFieldForIncrementalQueries",
        isTimestampFieldForIncrementalQueries
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SourceFieldProperties
  ) extends zio.aws.appflow.model.SourceFieldProperties.ReadOnly {
    override val isRetrievable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isRetrievable())
      .map(value => value: Boolean)
    override val isQueryable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isQueryable())
      .map(value => value: Boolean)
    override val isTimestampFieldForIncrementalQueries: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isTimestampFieldForIncrementalQueries())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SourceFieldProperties
  ): zio.aws.appflow.model.SourceFieldProperties.ReadOnly = new Wrapper(impl)
}
