package zio.aws.appflow.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appflow.model.primitives.{ConnectorProfileName, ApiVersion}
import scala.jdk.CollectionConverters.*
final case class SourceFlowConfig(
    connectorType: zio.aws.appflow.model.ConnectorType,
    apiVersion: Optional[ApiVersion] = Optional.Absent,
    connectorProfileName: Optional[ConnectorProfileName] = Optional.Absent,
    sourceConnectorProperties: zio.aws.appflow.model.SourceConnectorProperties,
    incrementalPullConfig: Optional[
      zio.aws.appflow.model.IncrementalPullConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appflow.model.SourceFlowConfig = {
    import SourceFlowConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appflow.model.SourceFlowConfig
      .builder()
      .connectorType(connectorType.unwrap)
      .optionallyWith(
        apiVersion.map(value => ApiVersion.unwrap(value): java.lang.String)
      )(_.apiVersion)
      .optionallyWith(
        connectorProfileName.map(value =>
          ConnectorProfileName.unwrap(value): java.lang.String
        )
      )(_.connectorProfileName)
      .sourceConnectorProperties(sourceConnectorProperties.buildAwsValue())
      .optionallyWith(
        incrementalPullConfig.map(value => value.buildAwsValue())
      )(_.incrementalPullConfig)
      .build()
  }
  def asReadOnly: zio.aws.appflow.model.SourceFlowConfig.ReadOnly =
    zio.aws.appflow.model.SourceFlowConfig.wrap(buildAwsValue())
}
object SourceFlowConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appflow.model.SourceFlowConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appflow.model.SourceFlowConfig =
      zio.aws.appflow.model.SourceFlowConfig(
        connectorType,
        apiVersion.map(value => value),
        connectorProfileName.map(value => value),
        sourceConnectorProperties.asEditable,
        incrementalPullConfig.map(value => value.asEditable)
      )
    def connectorType: zio.aws.appflow.model.ConnectorType
    def apiVersion: Optional[ApiVersion]
    def connectorProfileName: Optional[ConnectorProfileName]
    def sourceConnectorProperties
        : zio.aws.appflow.model.SourceConnectorProperties.ReadOnly
    def incrementalPullConfig
        : Optional[zio.aws.appflow.model.IncrementalPullConfig.ReadOnly]
    def getConnectorType
        : ZIO[Any, Nothing, zio.aws.appflow.model.ConnectorType] =
      ZIO.succeed(connectorType)
    def getApiVersion: ZIO[Any, AwsError, ApiVersion] =
      AwsError.unwrapOptionField("apiVersion", apiVersion)
    def getConnectorProfileName: ZIO[Any, AwsError, ConnectorProfileName] =
      AwsError.unwrapOptionField("connectorProfileName", connectorProfileName)
    def getSourceConnectorProperties: ZIO[
      Any,
      Nothing,
      zio.aws.appflow.model.SourceConnectorProperties.ReadOnly
    ] = ZIO.succeed(sourceConnectorProperties)
    def getIncrementalPullConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appflow.model.IncrementalPullConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("incrementalPullConfig", incrementalPullConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appflow.model.SourceFlowConfig
  ) extends zio.aws.appflow.model.SourceFlowConfig.ReadOnly {
    override val connectorType: zio.aws.appflow.model.ConnectorType =
      zio.aws.appflow.model.ConnectorType.wrap(impl.connectorType())
    override val apiVersion: Optional[ApiVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.apiVersion())
      .map(value => zio.aws.appflow.model.primitives.ApiVersion(value))
    override val connectorProfileName: Optional[ConnectorProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorProfileName())
        .map(value =>
          zio.aws.appflow.model.primitives.ConnectorProfileName(value)
        )
    override val sourceConnectorProperties
        : zio.aws.appflow.model.SourceConnectorProperties.ReadOnly =
      zio.aws.appflow.model.SourceConnectorProperties
        .wrap(impl.sourceConnectorProperties())
    override val incrementalPullConfig
        : Optional[zio.aws.appflow.model.IncrementalPullConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.incrementalPullConfig())
        .map(value => zio.aws.appflow.model.IncrementalPullConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appflow.model.SourceFlowConfig
  ): zio.aws.appflow.model.SourceFlowConfig.ReadOnly = new Wrapper(impl)
}
